/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import cpw.mods.fml.common.API;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.common.versioning.VersionRange;

public abstract class ModUtil {
    public static boolean isModLoaded(String modname) {
        return Loader.isModLoaded((String)modname);
    }

    public static boolean isModLoaded(String modname, String versionRangeString) {
        if (!ModUtil.isModLoaded(modname)) {
            return false;
        }
        if (versionRangeString != null) {
            ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modname);
            ArtifactVersion modVersion = mod.getProcessedVersion();
            VersionRange versionRange = VersionParser.parseRange((String)versionRangeString);
            DefaultArtifactVersion requiredVersion = new DefaultArtifactVersion(modname, versionRange);
            return requiredVersion.containsVersion(modVersion);
        }
        return true;
    }

    public static boolean isAPILoaded(String apiName) {
        return ModUtil.isAPILoaded(apiName, null);
    }

    public static boolean isAPILoaded(String apiName, String versionRangeString) {
        Package apiPackage = Package.getPackage(apiName);
        if (apiPackage == null) {
            return false;
        }
        API apiAnnotation = apiPackage.getAnnotation(API.class);
        if (apiAnnotation == null) {
            return false;
        }
        if (versionRangeString != null) {
            String apiVersionString = apiAnnotation.apiVersion();
            if (apiVersionString == null) {
                return false;
            }
            VersionRange versionRange = VersionParser.parseRange((String)versionRangeString);
            DefaultArtifactVersion givenVersion = new DefaultArtifactVersion(apiName, apiVersionString);
            DefaultArtifactVersion requiredVersion = new DefaultArtifactVersion(apiName, versionRange);
            return requiredVersion.containsVersion((ArtifactVersion)givenVersion);
        }
        return true;
    }
}

