/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui.widgets;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmLogic;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.farming.multiblock.IFarmControllerInternal;
import net.minecraft.util.IIcon;

public class FarmLogicSlot
extends Widget {
    private final IFarmControllerInternal farmController;
    private final FarmDirection farmDirection;
    protected final ToolTip toolTip = new ToolTip(250){

        @Override
        public void refresh() {
            FarmLogicSlot.this.toolTip.clear();
            if (FarmLogicSlot.this.getLogic() == null) {
                return;
            }
            FarmLogicSlot.this.toolTip.add(FarmLogicSlot.this.getLogic().getName());
            FarmLogicSlot.this.toolTip.add("Fertilizer: " + FarmLogicSlot.this.getLogic().getFertilizerConsumption());
            FarmLogicSlot.this.toolTip.add("Water: " + FarmLogicSlot.this.getLogic().getWaterConsumption(FarmLogicSlot.this.farmController.getFarmLedgerDelegate().getHydrationModifier()));
        }
    };

    public FarmLogicSlot(IFarmControllerInternal farmController, WidgetManager manager, int xPos, int yPos, FarmDirection farmDirection) {
        super(manager, xPos, yPos);
        this.farmController = farmController;
        this.farmDirection = farmDirection;
    }

    private IFarmLogic getLogic() {
        return this.farmController.getFarmLogic(this.farmDirection);
    }

    private IIcon getIconIndex() {
        if (this.getLogic() == null) {
            return null;
        }
        return this.getLogic().getIcon();
    }

    @Override
    public void draw(int startX, int startY) {
        if (this.getIconIndex() != null) {
            Proxies.render.bindTexture(this.getLogic().getSpriteSheet());
            this.manager.gui.func_94065_a(startX + this.xPos, startY + this.yPos, this.getIconIndex(), 16, 16);
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            return this.toolTip;
        }
        return null;
    }
}

