/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api2.client.gui.controls.io.ValueFuncIO;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasMinimum;
import betterquesting.api2.client.gui.panels.bars.PanelHBarFill;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import bq_standard.tasks.TaskIslandLevel;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;

public class PanelTaskIslandLevel
extends CanvasMinimum {
    private final TaskIslandLevel task;
    private final IGuiRect initialRect;

    public PanelTaskIslandLevel(IGuiRect rect, TaskIslandLevel task) {
        super(rect);
        this.task = task;
        this.initialRect = rect;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        int width = this.initialRect.getWidth();
        float islandLevel = this.task.getUsersProgress(QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g)).floatValue();
        float levelPercent = islandLevel / this.task.amount;
        int barWidth = Math.min(160, width - 4);
        PanelHBarFill fillBar = new PanelHBarFill(new GuiTransform(GuiAlign.TOP_LEFT, (width - barWidth) / 2, 2, barWidth, 14, 0));
        fillBar.setFillColor(new GuiColorStatic(-16724993));
        fillBar.setFillDriver(new ValueFuncIO<Float>(() -> Float.valueOf(levelPercent)));
        this.addPanel(fillBar);
        this.addPanel(new PanelTextBox(new GuiTransform(GuiAlign.TOP_LEFT, 0, 5, width, 10, -1), String.format("%.1f / %.1f %s", Float.valueOf(islandLevel), Float.valueOf(this.task.amount), StatCollector.func_74838_a((String)"bq_standard.gui.islandlevelamount"))).setAlignment(1));
        this.recalcSizes();
    }
}

