/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.utils.ParticipantInfo;
import bq_standard.client.gui.tasks.PanelTaskIslandLevel;
import bq_standard.tasks.base.TaskProgressableBase;
import bq_standard.tasks.factory.FactoryTaskIslandLevel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import ru.justagod.cutter.invoke.Invoke;

public class TaskIslandLevel
extends TaskProgressableBase<Float> {
    public float amount = 100.0f;

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.amount = nbt.func_150297_b("amount", 5) ? nbt.func_74760_g("amount") : 100.0f;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74776_a("amount", this.amount);
        return nbt;
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.task.islandlevel";
    }

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryTaskIslandLevel.INSTANCE.getRegistryName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, Map.Entry<UUID, IQuest> quest) {
        return new PanelTaskIslandLevel(rect, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen screen, Map.Entry<UUID, IQuest> quest) {
        return null;
    }

    @Override
    public Float getUsersProgress(UUID uuid) {
        Float n = (Float)this.userProgress.get(uuid);
        return Float.valueOf(n == null ? 0.0f : n.floatValue());
    }

    @Override
    public Float readUserProgressFromNBT(NBTTagCompound nbt) {
        return Float.valueOf(nbt.func_74760_g("value"));
    }

    @Override
    public void writeUserProgressToNBT(NBTTagCompound nbt, Float progress) {
        nbt.func_74776_a("value", progress.floatValue());
    }

    @Override
    public void detect(ParticipantInfo pInfo, Map.Entry<UUID, IQuest> quest) {
        float previousProgress;
        if (this.isComplete(pInfo.UUID)) {
            return;
        }
        float playerLevel = Invoke.serverValue(() -> Float.valueOf(0.0f)).floatValue();
        if (playerLevel != (previousProgress = this.getUsersProgress(pInfo.UUID).floatValue())) {
            this.setUserProgress(pInfo.UUID, Float.valueOf(Math.min(playerLevel, this.amount)));
            if (this.getUsersProgress(pInfo.UUID).floatValue() >= this.amount) {
                this.setComplete(pInfo.UUID);
            }
            pInfo.markDirty(quest.getKey());
        }
    }
}

