/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.utils.ParticipantInfo;
import bq_standard.client.gui.tasks.PanelTaskLocation;
import bq_standard.tasks.ITaskTickable;
import bq_standard.tasks.base.TaskBase;
import bq_standard.tasks.factory.FactoryTaskLocation;
import codechicken.lib.math.MathHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;

public class TaskLocation
extends TaskBase
implements ITaskTickable {
    private static final HashMap<Integer, String> dimNameCache = new HashMap();
    public String name = "New Location";
    public String structure = "";
    public int biome = -1;
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public int dim = 0;
    public int range = -1;
    public boolean visible = false;
    public boolean hideInfo = false;
    public boolean invert = false;
    public boolean taxiCab = false;

    public static String getDimName(int dim) {
        if (dimNameCache.containsKey(dim)) {
            return dimNameCache.get(dim);
        }
        try {
            WorldProvider prov = DimensionManager.createProviderFor((int)dim);
            if (prov != null) {
                dimNameCache.put(dim, prov.func_80007_l());
                return prov.func_80007_l();
            }
            dimNameCache.put(dim, "" + dim);
            return "" + dim;
        }
        catch (Exception e) {
            dimNameCache.put(dim, "" + dim);
            return "" + dim;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i("name");
        this.x = nbt.func_74762_e("posX");
        this.y = nbt.func_74762_e("posY");
        this.z = nbt.func_74762_e("posZ");
        this.dim = nbt.func_74762_e("dimension");
        this.biome = nbt.func_150297_b("biome", 99) ? nbt.func_74762_e("biome") : -1;
        this.structure = nbt.func_74779_i("structure");
        this.range = nbt.func_74762_e("range");
        this.visible = nbt.func_74767_n("visible");
        this.hideInfo = nbt.func_74767_n("hideInfo");
        this.invert = nbt.func_74767_n("invert") || nbt.func_74767_n("invertDistance");
        this.taxiCab = nbt.func_74767_n("taxiCabDist");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("posX", this.x);
        nbt.func_74768_a("posY", this.y);
        nbt.func_74768_a("posZ", this.z);
        nbt.func_74768_a("dimension", this.dim);
        nbt.func_74768_a("biome", this.biome);
        nbt.func_74778_a("structure", this.structure);
        nbt.func_74768_a("range", this.range);
        nbt.func_74757_a("visible", this.visible);
        nbt.func_74757_a("hideInfo", this.hideInfo);
        nbt.func_74757_a("invert", this.invert);
        nbt.func_74757_a("taxiCabDist", this.taxiCab);
        return nbt;
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.task.location";
    }

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryTaskLocation.INSTANCE.getRegistryName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, Map.Entry<UUID, IQuest> quest) {
        return new PanelTaskLocation(rect, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, Map.Entry<UUID, IQuest> quest) {
        return null;
    }

    @Override
    public void detect(@Nonnull ParticipantInfo pInfo, Map.Entry<UUID, IQuest> quest) {
        this.internalDetect(pInfo, quest);
    }

    private void internalDetect(@Nonnull ParticipantInfo pInfo, Map.Entry<UUID, IQuest> quest) {
        if (!pInfo.PLAYER.func_70089_S() || !(pInfo.PLAYER instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)pInfo.PLAYER;
        boolean flag = false;
        if (playerMP.field_71093_bK == this.dim && (this.range <= 0 || this.getDistance((EntityPlayer)playerMP) <= (double)this.range)) {
            if (this.biome >= 0 && this.biome != playerMP.func_71121_q().func_72807_a((int)MathHelper.floor_double((double)playerMP.field_70165_t), (int)MathHelper.floor_double((double)playerMP.field_70161_v)).field_76756_M) {
                if (!this.invert) {
                    return;
                }
            } else if (!StringUtils.func_151246_b((String)this.structure) && playerMP.func_71121_q().func_72863_F().func_147416_a((World)playerMP.func_71121_q(), this.structure, MathHelper.floor_double((double)playerMP.field_70165_t), MathHelper.floor_double((double)playerMP.field_70163_u), MathHelper.floor_double((double)playerMP.field_70161_v)) == null) {
                if (!this.invert) {
                    return;
                }
            } else {
                Vec3 tPos;
                Vec3 pPos;
                MovingObjectPosition mop;
                flag = this.visible && this.range > 0 ? (mop = playerMP.field_70170_p.func_147447_a(pPos = Vec3.func_72443_a((double)playerMP.field_70165_t, (double)(playerMP.field_70163_u + (double)playerMP.func_70047_e()), (double)playerMP.field_70161_v), tPos = Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z), false, true, false)) == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK : true;
            }
        }
        if (flag != this.invert) {
            pInfo.ALL_UUIDS.forEach(uuid -> {
                if (!this.isComplete((UUID)uuid)) {
                    this.setComplete((UUID)uuid);
                }
            });
            pInfo.markDirtyParty(quest.getKey());
        }
    }

    private double getDistance(EntityPlayer player) {
        if (!this.taxiCab) {
            return player.func_70011_f((double)this.x, (double)this.y, (double)this.z);
        }
        return Math.abs(player.field_70165_t - (double)this.x) + Math.abs(player.field_70163_u - (double)this.y) + Math.abs(player.field_70161_v - (double)this.z);
    }

    @Override
    public void tickTask(@Nonnull ParticipantInfo pInfo, @Nonnull Map.Entry<UUID, IQuest> quest) {
        if (pInfo.PLAYER.field_70173_aa % 100 == 0) {
            this.internalDetect(pInfo, quest);
        }
    }

    @Override
    public List<String> getTextsForSearch() {
        return Collections.singletonList(TaskLocation.getDimName(this.dim));
    }
}

