/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib3.geo.render;

import org.apache.commons.lang3.ArrayUtils;
import software.bernie.geckolib3.geo.raw.pojo.Bone;
import software.bernie.geckolib3.geo.raw.pojo.Cube;
import software.bernie.geckolib3.geo.raw.pojo.ModelProperties;
import software.bernie.geckolib3.geo.raw.tree.RawBoneGroup;
import software.bernie.geckolib3.geo.raw.tree.RawGeometryTree;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoCube;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.util.VectorUtils;
import software.bernie.libs.vecmath.Vector3f;

public class GeoBuilder {
    public static GeoModel constructGeoModel(RawGeometryTree geometryTree) {
        GeoModel model = new GeoModel();
        model.properties = geometryTree.properties;
        for (RawBoneGroup rawBone : geometryTree.topLevelBones.values()) {
            model.topLevelBones.add(GeoBuilder.constructBone(rawBone, geometryTree.properties, null));
        }
        return model;
    }

    private static GeoBone constructBone(RawBoneGroup bone, ModelProperties properties, GeoBone parent) {
        GeoBone geoBone = new GeoBone();
        Bone rawBone = bone.selfBone;
        Vector3f rotation = VectorUtils.convertDoubleToFloat(VectorUtils.fromArray(rawBone.getRotation()));
        Vector3f pivot = VectorUtils.convertDoubleToFloat(VectorUtils.fromArray(rawBone.getPivot()));
        rotation.x *= -1.0f;
        rotation.y *= -1.0f;
        geoBone.mirror = rawBone.getMirror();
        geoBone.dontRender = rawBone.getNeverRender();
        geoBone.reset = rawBone.getReset();
        geoBone.inflate = rawBone.getInflate();
        geoBone.parent = parent;
        geoBone.setModelRendererName(rawBone.getName());
        geoBone.setRotationX((float)Math.toRadians(rotation.x));
        geoBone.setRotationY((float)Math.toRadians(rotation.y));
        geoBone.setRotationZ((float)Math.toRadians(rotation.z));
        geoBone.rotationPointX = -pivot.x;
        geoBone.rotationPointY = pivot.y;
        geoBone.rotationPointZ = pivot.z;
        if (!ArrayUtils.isEmpty((Object[])rawBone.getCubes())) {
            for (Cube cube : rawBone.getCubes()) {
                geoBone.childCubes.add(GeoCube.createFromPojoCube(cube, properties, geoBone.inflate == null ? null : Double.valueOf(geoBone.inflate / 16.0), geoBone.mirror));
            }
        }
        for (RawBoneGroup child : bone.children.values()) {
            geoBone.childBones.add(GeoBuilder.constructBone(child, properties, geoBone));
        }
        return geoBone;
    }
}

