/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib3.model;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.animation.AnimationTicker;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimatableModel;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.processor.AnimationProcessor;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.file.AnimationFile;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.model.provider.IAnimatableModelProvider;
import software.bernie.geckolib3.resource.GeckoLibCache;
import software.bernie.geckolib3.util.MolangUtils;
import software.bernie.libs.eliotlash.molang.MolangParser;

public abstract class AnimatedGeoModel<T extends IAnimatable>
extends GeoModelProvider<T>
implements IAnimatableModel<T>,
IAnimatableModelProvider<T> {
    private final AnimationProcessor animationProcessor = new AnimationProcessor(this);
    private GeoModel currentModel;
    private static final Set<ResourceLocation> ALREADY_REPORT = new HashSet<ResourceLocation>();

    protected AnimatedGeoModel() {
    }

    public void registerBone(GeoBone bone) {
        this.registerModelRenderer(bone);
        bone.childBones.forEach(this::registerBone);
    }

    @Override
    public void setLivingAnimations(T entity, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        AnimationData data = entity.getFactory().getOrCreateAnimationData(uniqueID);
        if (data.ticker == null) {
            AnimationTicker ticker = new AnimationTicker(data);
            data.ticker = ticker;
            FMLCommonHandler.instance().bus().register((Object)ticker);
        }
        this.seekTime = !Minecraft.func_71410_x().func_147113_T() || data.shouldPlayWhilePaused ? data.tick + (double)Minecraft.func_71410_x().field_71428_T.field_74281_c : data.tick;
        AnimationEvent<T> predicate = customPredicate == null ? new AnimationEvent<T>(entity, 0.0f, 0.0f, 0.0f, false, Collections.emptyList()) : customPredicate;
        predicate.animationTick = this.seekTime;
        this.animationProcessor.preAnimationSetup((IAnimatable)predicate.getAnimatable(), this.seekTime);
        if (!this.animationProcessor.getModelRendererList().isEmpty()) {
            this.animationProcessor.tickAnimation((IAnimatable)entity, uniqueID, this.seekTime, predicate, GeckoLibCache.getInstance().parser, this.shouldCrashOnMissing);
        }
    }

    @Override
    public AnimationProcessor getAnimationProcessor() {
        return this.animationProcessor;
    }

    public void registerModelRenderer(IBone modelRenderer) {
        this.animationProcessor.registerModelRenderer(modelRenderer);
    }

    @Override
    public Animation getAnimation(String name, IAnimatable animatable) {
        HashMap<ResourceLocation, AnimationFile> paths = GeckoLibCache.getInstance().getAnimations();
        AnimationFile file = paths.get(this.getAnimationFileLocation(animatable));
        if (file == null) {
            return null;
        }
        return file.getAnimation(name);
    }

    private static void reportCouldNotFindModel(ResourceLocation location) {
        if (ALREADY_REPORT.contains(location)) {
            return;
        }
        Minecraft.func_71410_x().field_71439_g.func_146105_b((IChatComponent)new ChatComponentText("\u00a7cCould not find model: "));
        Minecraft.func_71410_x().field_71439_g.func_146105_b((IChatComponent)new ChatComponentText("\u00a7c - " + location.toString()));
        ALREADY_REPORT.add(location);
    }

    @Override
    public GeoModel getModel(ResourceLocation location) {
        GeoModel model = super.getModel(location);
        if (model == null) {
            AnimatedGeoModel.reportCouldNotFindModel(location);
            this.animationProcessor.clearModelRendererList();
            this.currentModel = null;
            return null;
        }
        if (model != this.currentModel) {
            this.animationProcessor.clearModelRendererList();
            for (GeoBone bone : model.topLevelBones) {
                this.registerBone(bone);
            }
            this.currentModel = model;
        }
        return model;
    }

    @Override
    public void setMolangQueries(IAnimatable animatable, double currentTick) {
        MolangParser parser = GeckoLibCache.getInstance().parser;
        Minecraft minecraftInstance = Minecraft.func_71410_x();
        parser.setValue("query.actor_count", minecraftInstance.field_71441_e.field_72996_f.size());
        parser.setValue("query.time_of_day", MolangUtils.normalizeTime(minecraftInstance.field_71441_e.func_82737_E()));
        parser.setValue("query.moon_phase", minecraftInstance.field_71441_e.func_72853_d());
        if (animatable instanceof Entity) {
            parser.setValue("query.is_on_ground", MolangUtils.booleanToFloat(((Entity)animatable).field_70122_E));
            parser.setValue("query.is_in_water", MolangUtils.booleanToFloat(((Entity)animatable).func_70090_H()));
            parser.setValue("query.is_in_water_or_rain", MolangUtils.booleanToFloat(((Entity)animatable).func_70026_G()));
            if (animatable instanceof EntityLivingBase) {
                EntityLivingBase livingEntity = (EntityLivingBase)animatable;
                parser.setValue("query.health", livingEntity.func_110143_aJ());
                parser.setValue("query.max_health", livingEntity.func_110138_aP());
                parser.setValue("query.is_on_fire", MolangUtils.booleanToFloat(livingEntity.func_70027_ad()));
                double dx = livingEntity.field_70159_w;
                double dz = livingEntity.field_70179_y;
                float groundSpeed = MathHelper.func_76129_c((float)((float)(dx * dx + dz * dz)));
                parser.setValue("query.ground_speed", groundSpeed);
                float yawSpeed = this.getYaw(livingEntity, Minecraft.func_71410_x().field_71428_T.field_74281_c) - this.getYaw(livingEntity, (float)((double)Minecraft.func_71410_x().field_71428_T.field_74281_c - 0.1));
                parser.setValue("query.yaw_speed", yawSpeed);
            }
        }
    }

    private float getYaw(EntityLivingBase entity, float tick) {
        return entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * tick;
    }

    @Override
    public double getCurrentTick() {
        return (double)Minecraft.func_71386_F() / 50.0;
    }
}

