/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib3.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.RegistryDelegate;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.world.WorldServer;
import software.bernie.geckolib3.network.ISyncable;
import software.bernie.geckolib3.network.packet.SyncAnimationPacket;

public class GeckoLibNetwork {
    private static final Map<String, Supplier<ISyncable>> SYNCABLES = new HashMap<String, Supplier<ISyncable>>();
    private static final SimpleNetworkWrapper CHANNEL = new SimpleNetworkWrapper("GeckoLibChannel");

    public static void initialize() {
        CHANNEL.registerMessage((IMessageHandler)new SyncAnimationPacket(), SyncAnimationPacket.class, 0, Side.CLIENT);
    }

    public static void syncAnimation(EntityPlayer player, ISyncable syncable, int id, int state) {
        String key = syncable.getSyncKey();
        if (!SYNCABLES.containsKey(key)) {
            throw new IllegalArgumentException("Syncable not registered for " + key);
        }
        GeckoLibNetwork.sendToTrackers(player, other -> new SyncAnimationPacket((Entity)other, id, state));
    }

    public static void sendToTrackers(EntityPlayer player, Function<EntityPlayer, IMessage> packet) {
        EntityTracker tracker = ((WorldServer)player.field_70170_p).func_73039_n();
        CHANNEL.sendTo(packet.apply(player), (EntityPlayerMP)player);
        for (EntityPlayer other : tracker.getTrackingPlayers((Entity)player)) {
            CHANNEL.sendTo(packet.apply(other), (EntityPlayerMP)other);
        }
    }

    public static ISyncable getSyncable(String key) {
        Supplier<ISyncable> delegate = SYNCABLES.get(key);
        return delegate == null ? null : delegate.get();
    }

    public static <T extends Item> void registerSyncable(T entry) {
        RegistryDelegate delegate = entry.delegate;
        String key = ((ISyncable)entry).getSyncKey();
        if (SYNCABLES.putIfAbsent(key, () -> (ISyncable)delegate.get()) != null) {
            throw new IllegalArgumentException("Syncable already registered for " + key);
        }
    }
}

