/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib3.renderers.geo;

import java.nio.FloatBuffer;
import java.util.Collections;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimatableModel;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.geckolib3.util.AnimationUtils;
import software.bernie.libs.eliotlash.mclib.utils.Interpolations;

public abstract class GeoEntityRenderer<T extends EntityLivingBase>
extends Render
implements IGeoRenderer<T> {
    public T currentEntity;
    private final AnimatedGeoModel<T> modelProvider;
    protected FloatBuffer brightnessBuffer = GLAllocation.func_74529_h((int)4);
    private static final DynamicTexture TEXTURE_BRIGHTNESS;

    protected GeoEntityRenderer(AnimatedGeoModel<T> modelProvider) {
        this.modelProvider = modelProvider;
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.render((EntityLivingBase)entity, x, y, z, entityYaw, partialTicks);
    }

    private void render(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.currentEntity = entity;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        boolean shouldSit = ((EntityLivingBase)entity).field_70154_o != null && ((EntityLivingBase)entity).field_70154_o.shouldRiderSit();
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        entityModelData.isChild = entity.func_70631_g_();
        float f = Interpolations.lerpYaw(((EntityLivingBase)entity).field_70760_ar, ((EntityLivingBase)entity).field_70761_aq, partialTicks);
        float f1 = Interpolations.lerpYaw(((EntityLivingBase)entity).field_70758_at, ((EntityLivingBase)entity).field_70759_as, partialTicks);
        float netHeadYaw = f1 - f;
        if (shouldSit && ((EntityLivingBase)entity).field_70154_o instanceof EntityLivingBase) {
            EntityLivingBase livingentity = (EntityLivingBase)((EntityLivingBase)entity).field_70154_o;
            f = Interpolations.lerpYaw(livingentity.field_70760_ar, livingentity.field_70761_aq, partialTicks);
            netHeadYaw = f1 - f;
            float f3 = MathHelper.func_76142_g((float)netHeadYaw);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            netHeadYaw = f1 - f;
        }
        float headPitch = Interpolations.lerp(((EntityLivingBase)entity).field_70127_C, ((EntityLivingBase)entity).field_70125_A, partialTicks);
        float f7 = this.handleRotationFloat(entity, partialTicks);
        this.applyRotations(entity, f7, f, partialTicks);
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!shouldSit && entity.func_70089_S()) {
            limbSwingAmount = Interpolations.lerp(((EntityLivingBase)entity).field_70722_aY, ((EntityLivingBase)entity).field_70721_aZ, partialTicks);
            limbSwing = ((EntityLivingBase)entity).field_70754_ba - ((EntityLivingBase)entity).field_70721_aZ * (1.0f - partialTicks);
            if (entity.func_70631_g_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        entityModelData.headPitch = -headPitch;
        entityModelData.netHeadYaw = -netHeadYaw;
        AnimationEvent<IAnimatable> predicate = new AnimationEvent<IAnimatable>((IAnimatable)entity, limbSwing, limbSwingAmount, partialTicks, !(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f), Collections.singletonList(entityModelData));
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(entity));
        if (model == null) {
            GL11.glPopMatrix();
            return;
        }
        if (this.modelProvider instanceof IAnimatableModel) {
            this.modelProvider.setLivingAnimations(entity, this.getUniqueID(entity), (AnimationEvent)predicate);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.01f, (float)0.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.func_110775_a((Entity)entity));
        Color renderColor = this.getRenderColor(entity, partialTicks);
        boolean flag = this.setDoRenderBrightness(entity, partialTicks);
        this.render(model, entity, partialTicks, (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        if (flag) {
            this.unsetBrightness();
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return this.getTextureLocation((T)((EntityLivingBase)entity));
    }

    @Override
    public GeoModelProvider getGeoModelProvider() {
        return this.modelProvider;
    }

    @Override
    public Integer getUniqueID(T animatable) {
        return animatable.func_110124_au().hashCode();
    }

    protected void applyRotations(T entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
        String s;
        if (!entityLiving.func_70608_bn()) {
            GL11.glRotatef((float)(180.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (((EntityLivingBase)entityLiving).field_70725_aQ > 0) {
            float f = ((float)((EntityLivingBase)entityLiving).field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            GL11.glRotatef((float)(f * this.getDeathMaxRotation(entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (!(!((EntityLiving)entityLiving).func_94056_bM() && !(entityLiving instanceof EntityPlayer) || !(s = EnumChatFormatting.func_110646_a((String)entityLiving.func_70005_c_())).equals("Dinnerbone") && !s.equals("Grumm") || entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_82238_cc())) {
            GL11.glTranslatef((float)0.0f, (float)(((EntityLivingBase)entityLiving).field_70131_O + 0.1f), (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected boolean isVisible(T livingEntityIn) {
        return !livingEntityIn.func_82150_aj();
    }

    private static float getFacingAngle(EnumFacing facingIn) {
        switch (facingIn) {
            case SOUTH: {
                return 90.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected float getDeathMaxRotation(T entityLivingBaseIn) {
        return 90.0f;
    }

    protected float getSwingProgress(T livingBase, float partialTickTime) {
        return livingBase.func_70678_g(partialTickTime);
    }

    protected float handleRotationFloat(T livingBase, float partialTicks) {
        return (float)((EntityLivingBase)livingBase).field_70173_aa + partialTicks;
    }

    @Override
    public ResourceLocation getTextureLocation(T instance) {
        return this.modelProvider.getTextureLocation(instance);
    }

    protected boolean setDoRenderBrightness(T entityLivingBaseIn, float partialTicks) {
        return this.setBrightness(entityLivingBaseIn, partialTicks, true);
    }

    protected boolean setBrightness(T entitylivingbaseIn, float partialTicks, boolean combineTextures) {
        boolean flag1;
        float f = entitylivingbaseIn.func_70013_c(partialTicks);
        int i = 0;
        boolean flag = (i >> 24 & 0xFF) > 0;
        boolean bl = flag1 = ((EntityLivingBase)entitylivingbaseIn).field_70737_aN > 0 || ((EntityLivingBase)entitylivingbaseIn).field_70725_aQ > 0;
        if (!flag && !flag1) {
            return false;
        }
        if (!flag && !combineTextures) {
            return false;
        }
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        this.brightnessBuffer.position(0);
        if (flag1) {
            this.brightnessBuffer.put(1.0f);
            this.brightnessBuffer.put(0.0f);
            this.brightnessBuffer.put(0.0f);
            this.brightnessBuffer.put(0.3f);
        } else {
            float f1 = (float)(i >> 24 & 0xFF) / 255.0f;
            float f2 = (float)(i >> 16 & 0xFF) / 255.0f;
            float f3 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f4 = (float)(i & 0xFF) / 255.0f;
            this.brightnessBuffer.put(f2);
            this.brightnessBuffer.put(f3);
            this.brightnessBuffer.put(f4);
            this.brightnessBuffer.put(1.0f - f1);
        }
        this.brightnessBuffer.flip();
        return true;
    }

    protected void unsetBrightness() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    static {
        AnimationController.addModelFetcher(object -> object instanceof Entity ? (IAnimatableModel)((Object)AnimationUtils.getGeoModelForEntity((Entity)object)) : null);
        TEXTURE_BRIGHTNESS = new DynamicTexture(16, 16);
        int[] aint = TEXTURE_BRIGHTNESS.func_110565_c();
        IntStream.range(0, 256).forEach(i -> {
            aint[i] = -1;
        });
        TEXTURE_BRIGHTNESS.func_110564_a();
    }
}

