/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib3.renderers.geo;

import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.geckolib3.util.GeckoLibUtil;

public abstract class GeoItemRenderer<T extends Item>
implements IItemRenderer,
IGeoRenderer<T> {
    protected AnimatedGeoModel<T> modelProvider;
    public ItemStack currentItemStack;

    public GeoItemRenderer(AnimatedGeoModel<T> modelProvider) {
        this.modelProvider = modelProvider;
    }

    public void setModel(AnimatedGeoModel<T> model) {
        this.modelProvider = model;
    }

    @Override
    public AnimatedGeoModel<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack stack, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        this.render(stack.func_77973_b(), stack, type);
    }

    public void renderFirstPerson() {
        GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    public void renderThirdPerson() {
    }

    public void renderEntity() {
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
    }

    public void renderInFrame() {
        GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    public void renderInventory() {
    }

    public void render(T animatable, ItemStack itemStack, IItemRenderer.ItemRenderType type) {
        this.currentItemStack = itemStack;
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(animatable));
        if (model == null) {
            return;
        }
        AnimationEvent<IAnimatable> itemEvent = new AnimationEvent<IAnimatable>((IAnimatable)animatable, 0.0f, 0.0f, Minecraft.func_71410_x().field_71428_T.field_74281_c, false, Collections.singletonList(itemStack));
        this.modelProvider.setLivingAnimations((IAnimatable)animatable, this.getUniqueID(animatable), itemEvent);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.01f, (float)0.0f);
        GL11.glTranslatef((float)0.5f, (float)-0.05f, (float)0.5f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        switch (type) {
            case EQUIPPED_FIRST_PERSON: {
                this.renderFirstPerson();
                break;
            }
            case EQUIPPED: {
                this.renderThirdPerson();
                break;
            }
            case ENTITY: {
                this.renderEntity();
                if (!RenderItem.field_82407_g) break;
                this.renderInFrame();
                break;
            }
            case INVENTORY: {
                this.renderInventory();
            }
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTextureLocation(animatable));
        Color renderColor = this.getRenderColor(animatable, 0.0f);
        this.render(model, animatable, 0.0f, (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        GL11.glPopMatrix();
    }

    @Override
    public ResourceLocation getTextureLocation(T instance) {
        return this.modelProvider.getTextureLocation(instance);
    }

    @Override
    public Integer getUniqueID(T animatable) {
        return GeckoLibUtil.getIDFromStack(this.currentItemStack);
    }

    static {
        AnimationController.addModelFetcher(object -> {
            Item item;
            IItemRenderer renderer;
            if (object instanceof Item && (renderer = MinecraftForgeClient.getItemRenderer((ItemStack)new ItemStack(item = (Item)object), (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.EQUIPPED)) instanceof GeoItemRenderer) {
                return ((GeoItemRenderer)renderer).getGeoModelProvider();
            }
            return null;
        });
    }
}

