/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib3.renderers.geo;

import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoCube;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.geo.render.built.GeoQuad;
import software.bernie.geckolib3.geo.render.built.GeoVertex;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.util.GeoUtils;
import software.bernie.geckolib3.util.MatrixStack;
import software.bernie.libs.vecmath.Vector3f;
import software.bernie.libs.vecmath.Vector4f;

public interface IGeoRenderer<T> {
    public static final MatrixStack MATRIX_STACK = new MatrixStack();
    public static final Vector3f NORMAL = new Vector3f();
    public static final Vector4f POSITION = new Vector4f();

    default public void render(GeoModel model, T animatable, float partialTicks, float red, float green, float blue, float alpha) {
        GL11.glDisable((int)2884);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        this.renderEarly(animatable, partialTicks, red, green, blue, alpha);
        this.renderLate(animatable, partialTicks, red, green, blue, alpha);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        for (GeoBone group : model.topLevelBones) {
            this.renderRecursively(tess, group, red, green, blue, alpha);
        }
        Tessellator.field_78398_a.func_78381_a();
        this.renderAfter(animatable, partialTicks, red, green, blue, alpha);
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glEnable((int)2884);
    }

    default public void renderInScreen(GeoModel model, float red, float green, float blue, float alpha) {
        GL11.glDisable((int)2884);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        for (GeoBone group : model.topLevelBones) {
            GeoUtils.copy(group.getInitialSnapshot(), group);
            this.renderRecursively(tess, group, red, green, blue, alpha);
        }
        Tessellator.field_78398_a.func_78381_a();
        GL11.glEnable((int)2884);
    }

    default public void renderRecursively(Tessellator builder, GeoBone bone, float red, float green, float blue, float alpha) {
        MATRIX_STACK.push();
        MATRIX_STACK.translate(bone);
        MATRIX_STACK.moveToPivot(bone);
        MATRIX_STACK.rotate(bone);
        MATRIX_STACK.scale(bone);
        MATRIX_STACK.moveBackFromPivot(bone);
        if (!bone.isHidden) {
            boolean offDepthMask;
            boolean bl = offDepthMask = bone.getName().charAt(0) == 'O' && bone.getName().charAt(1) == 'P';
            if (offDepthMask) {
                builder.func_78381_a();
                builder.func_78382_b();
            }
            for (GeoCube cube : bone.childCubes) {
                MATRIX_STACK.push();
                this.renderCube(builder, cube, red, green, blue, alpha);
                MATRIX_STACK.pop();
            }
            if (offDepthMask) {
                GL11.glDepthMask((boolean)false);
                builder.func_78381_a();
                GL11.glDepthMask((boolean)true);
                builder.func_78382_b();
            }
            for (GeoBone childBone : bone.childBones) {
                this.renderRecursively(builder, childBone, red, green, blue, alpha);
            }
        }
        MATRIX_STACK.pop();
    }

    default public void renderCube(Tessellator builder, GeoCube cube, float red, float green, float blue, float alpha) {
        MATRIX_STACK.moveToPivot(cube);
        MATRIX_STACK.rotate(cube);
        MATRIX_STACK.moveBackFromPivot(cube);
        for (GeoQuad quad : cube.quads) {
            if (quad == null) continue;
            NORMAL.set(quad.normal.getX(), quad.normal.getY(), quad.normal.getZ());
            MATRIX_STACK.getNormalMatrix().transform(NORMAL);
            if ((cube.size.y == 0.0f || cube.size.z == 0.0f) && IGeoRenderer.NORMAL.x < 0.0f) {
                IGeoRenderer.NORMAL.x *= -1.0f;
            }
            if ((cube.size.x == 0.0f || cube.size.z == 0.0f) && IGeoRenderer.NORMAL.y < 0.0f) {
                IGeoRenderer.NORMAL.y *= -1.0f;
            }
            if ((cube.size.x == 0.0f || cube.size.y == 0.0f) && IGeoRenderer.NORMAL.z < 0.0f) {
                IGeoRenderer.NORMAL.z *= -1.0f;
            }
            for (GeoVertex vertex : quad.vertices) {
                POSITION.set(vertex.position.x, vertex.position.y, vertex.position.z, 1.0f);
                MATRIX_STACK.getModelMatrix().transform(POSITION);
                builder.func_78369_a(red, green, blue, alpha);
                builder.func_78375_b(IGeoRenderer.NORMAL.x, IGeoRenderer.NORMAL.y, IGeoRenderer.NORMAL.z);
                builder.func_78374_a((double)IGeoRenderer.POSITION.x, (double)IGeoRenderer.POSITION.y, (double)IGeoRenderer.POSITION.z, (double)vertex.textureU, (double)vertex.textureV);
            }
        }
    }

    public GeoModelProvider<T> getGeoModelProvider();

    public ResourceLocation getTextureLocation(T var1);

    default public void renderEarly(T animatable, float ticks, float red, float green, float blue, float partialTicks) {
    }

    default public void renderLate(T animatable, float ticks, float red, float green, float blue, float partialTicks) {
    }

    default public void renderAfter(T animatable, float ticks, float red, float green, float blue, float partialTicks) {
    }

    default public Color getRenderColor(T animatable, float partialTicks) {
        return Color.WHITE;
    }

    default public Integer getUniqueID(T animatable) {
        return animatable.hashCode();
    }
}

