/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib3.util;

import java.util.Stack;
import org.lwjgl.util.vector.Quaternion;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoCube;
import software.bernie.libs.vecmath.Matrix3f;
import software.bernie.libs.vecmath.Matrix4f;
import software.bernie.libs.vecmath.Vector3f;

public class MatrixStack {
    private final Stack<Matrix4f> model = new Stack();
    private final Stack<Matrix3f> normal = new Stack();
    private final Matrix4f tempModelMatrix = new Matrix4f();
    private final Matrix3f tempNormalMatrix = new Matrix3f();
    private final float[] tempArray = new float[16];

    public MatrixStack() {
        Matrix4f model = new Matrix4f();
        Matrix3f normal = new Matrix3f();
        model.setIdentity();
        normal.setIdentity();
        this.model.add(model);
        this.normal.add(normal);
    }

    public Matrix4f getModelMatrix() {
        return this.model.peek();
    }

    public Matrix3f getNormalMatrix() {
        return this.normal.peek();
    }

    public void push() {
        this.model.add(new Matrix4f(this.model.peek()));
        this.normal.add(new Matrix3f(this.normal.peek()));
    }

    public void pop() {
        if (this.model.size() == 1) {
            throw new IllegalStateException("A one level stack can't be popped!");
        }
        this.model.pop();
        this.normal.pop();
    }

    public void translate(float x, float y, float z) {
        this.translate(new Vector3f(x, y, z));
    }

    public void translate(Vector3f vec) {
        this.tempModelMatrix.setIdentity();
        this.tempModelMatrix.setTranslation(vec);
        this.model.peek().mul(this.tempModelMatrix);
    }

    public void moveToPivot(GeoCube cube) {
        Vector3f pivot = cube.pivot;
        this.translate(pivot.x / 16.0f, pivot.y / 16.0f, pivot.z / 16.0f);
    }

    public void moveBackFromPivot(GeoCube cube) {
        Vector3f pivot = cube.pivot;
        this.translate(-pivot.x / 16.0f, -pivot.y / 16.0f, -pivot.z / 16.0f);
    }

    public void moveToPivot(GeoBone bone) {
        this.translate(bone.rotationPointX / 16.0f, bone.rotationPointY / 16.0f, bone.rotationPointZ / 16.0f);
    }

    public void moveBackFromPivot(GeoBone bone) {
        this.translate(-bone.rotationPointX / 16.0f, -bone.rotationPointY / 16.0f, -bone.rotationPointZ / 16.0f);
    }

    public void translate(GeoBone bone) {
        this.translate(-bone.getPositionX() / 16.0f, bone.getPositionY() / 16.0f, bone.getPositionZ() / 16.0f);
    }

    public void scale(float x, float y, float z) {
        this.tempModelMatrix.setIdentity();
        this.tempModelMatrix.m00 = x;
        this.tempModelMatrix.m11 = y;
        this.tempModelMatrix.m22 = z;
        this.model.peek().mul(this.tempModelMatrix);
        if (x < 0.0f || y < 0.0f || z < 0.0f) {
            this.tempNormalMatrix.setIdentity();
            this.tempNormalMatrix.m00 = x < 0.0f ? -1.0f : 1.0f;
            this.tempNormalMatrix.m11 = y < 0.0f ? -1.0f : 1.0f;
            this.tempNormalMatrix.m22 = z < 0.0f ? -1.0f : 1.0f;
            this.normal.peek().mul(this.tempNormalMatrix);
        }
    }

    public void scale(GeoBone bone) {
        this.scale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public void rotateX(float radian) {
        this.tempModelMatrix.setIdentity();
        this.tempModelMatrix.rotX(radian);
        this.tempNormalMatrix.setIdentity();
        this.tempNormalMatrix.rotX(radian);
        this.model.peek().mul(this.tempModelMatrix);
        this.normal.peek().mul(this.tempNormalMatrix);
    }

    public void rotateY(float radian) {
        this.tempModelMatrix.setIdentity();
        this.tempModelMatrix.rotY(radian);
        this.tempNormalMatrix.setIdentity();
        this.tempNormalMatrix.rotY(radian);
        this.model.peek().mul(this.tempModelMatrix);
        this.normal.peek().mul(this.tempNormalMatrix);
    }

    public void rotateZ(float radian) {
        this.tempModelMatrix.setIdentity();
        this.tempModelMatrix.rotZ(radian);
        this.tempNormalMatrix.setIdentity();
        this.tempNormalMatrix.rotZ(radian);
        this.model.peek().mul(this.tempModelMatrix);
        this.normal.peek().mul(this.tempNormalMatrix);
    }

    public void rotate(GeoBone bone) {
        if (bone.getRotationZ() != 0.0f) {
            this.rotateZ(bone.getRotationZ());
        }
        if (bone.getRotationY() != 0.0f) {
            this.rotateY(bone.getRotationY());
        }
        if (bone.getRotationX() != 0.0f) {
            this.rotateX(bone.getRotationX());
        }
    }

    public void rotate(GeoCube bone) {
        Vector3f rotation = bone.rotation;
        Matrix4f matrix4f = new Matrix4f();
        Matrix3f matrix3f = new Matrix3f();
        this.tempModelMatrix.setIdentity();
        matrix4f.rotZ(rotation.z);
        this.tempModelMatrix.mul(matrix4f);
        matrix4f.rotY(rotation.y);
        this.tempModelMatrix.mul(matrix4f);
        matrix4f.rotX(rotation.x);
        this.tempModelMatrix.mul(matrix4f);
        this.tempNormalMatrix.setIdentity();
        matrix3f.rotZ(rotation.z);
        this.tempNormalMatrix.mul(matrix3f);
        matrix3f.rotY(rotation.y);
        this.tempNormalMatrix.mul(matrix3f);
        matrix3f.rotX(rotation.x);
        this.tempNormalMatrix.mul(matrix3f);
        this.model.peek().mul(this.tempModelMatrix);
        this.normal.peek().mul(this.tempNormalMatrix);
    }

    private Quaternion fromAngles(float x, float y, float z) {
        float sx = (float)Math.sin(0.5f * x);
        float cx = (float)Math.cos(0.5f * x);
        float sy = (float)Math.sin(0.5f * y);
        float cy = (float)Math.cos(0.5f * y);
        float sz = (float)Math.sin(0.5f * z);
        float cz = (float)Math.cos(0.5f * z);
        float ox = sx * cy * cz + cx * sy * sz;
        float oy = cx * sy * cz - sx * cy * sz;
        float oz = sx * sy * cz + cx * cy * sz;
        float ow = cx * cy * cz - sx * sy * sz;
        return new Quaternion(ox, oy, oz, ow);
    }
}

