/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib3.world.storage;

import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;

public class GeckoLibIdTracker
extends WorldSavedData {
    private static final String NAME = "geckolib_ids";
    private final TObjectIntHashMap<String> usedIds = new TObjectIntHashMap();

    public GeckoLibIdTracker() {
        this(NAME);
    }

    public GeckoLibIdTracker(String name) {
        super(name);
    }

    public void func_76187_b(NBTTagCompound nbt) {
        this.usedIds.forEachEntry((key, value) -> {
            nbt.func_74768_a(key, value);
            return true;
        });
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.usedIds.clear();
        for (String key : this.usedIds.keySet()) {
            if (!nbt.func_74764_b(key)) continue;
            this.usedIds.put((Object)key, nbt.func_74762_e(key));
        }
    }

    public int getNextId(Type type) {
        int id = this.usedIds.get((Object)type.key) + 1;
        this.usedIds.put((Object)type.key, id);
        this.func_76185_a();
        return id;
    }

    public static GeckoLibIdTracker get(World world) {
        MapStorage storage = world.field_72988_C;
        GeckoLibIdTracker tracker = (GeckoLibIdTracker)storage.func_75742_a(GeckoLibIdTracker.class, NAME);
        if (tracker == null) {
            tracker = new GeckoLibIdTracker();
            storage.func_75745_a(NAME, (WorldSavedData)tracker);
        }
        return tracker;
    }

    public static enum Type {
        ITEM("Item");

        private final String key;

        private Type(String key) {
            this.key = key;
        }
    }
}

