/*
 * Decompiled with CFR 0.152.
 */
package gravisuite;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.BlockRelocatorPortal;
import gravisuite.GraviSuite;
import gravisuite.ServerProxy;
import gravisuite.TileEntityRelocatorPortal;
import gravisuite.item.ItemRelocator;
import gravisuite.item.Items;
import gravisuite.utils.Helpers;
import ic2.api.item.ElectricItem;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityPlasmaBall
extends EntityThrowable {
    public static final byte RELOCATOR_TELEPORT = 0;
    public static final byte RELOCATOR_PORTAL = 1;
    private EntityLivingBase ownerEntity;
    private double startX;
    private double startY;
    private double startZ;
    private double maxRange;
    private double speedPerTick;
    private double dischargeArmorValue;
    private byte actionType;
    private ItemRelocator.TeleportPoint targetTpPoint;

    public EntityPlasmaBall(World world, EntityLivingBase entityLiving, ItemRelocator.TeleportPoint tpPoint, byte entityType) {
        super(world, entityLiving);
        this.ownerEntity = entityLiving;
        this.startX = this.field_70165_t;
        this.startY = this.field_70163_u;
        this.startZ = this.field_70161_v;
        this.maxRange = 32.0;
        this.speedPerTick = 1.33;
        this.targetTpPoint = tpPoint;
        this.actionType = entityType;
        this.dischargeArmorValue = 500000.0;
        this.field_70180_af.func_75692_b(30, (Object)this.actionType);
    }

    public EntityPlasmaBall(World world) {
        super(world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(30, (Object)this.actionType);
        this.field_70180_af.func_82708_h(30);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public void func_70071_h_() {
        double distance;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && ((distance = this.func_70011_f(this.startX, this.startY, this.startZ)) >= this.maxRange || (double)this.field_70173_aa > this.maxRange / this.speedPerTick)) {
            this.func_70106_y();
        }
    }

    public void func_70109_d(NBTTagCompound nbt) {
        super.func_70109_d(nbt);
        nbt.func_74774_a("actionType", this.actionType);
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.actionType = nbt.func_74771_c("actionType");
    }

    public byte getActionType() {
        return this.field_70180_af.func_75683_a(30);
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (mop.field_72308_g != null) {
            if (this.actionType == 0) {
                if (mop.field_72308_g instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)mop.field_72308_g;
                    ItemStack itemstack = player.field_71071_by.field_70460_b[2];
                    if (itemstack != null && itemstack.func_77973_b() == Items.graviChestPlate) {
                        if (ElectricItem.manager.getCharge(itemstack) < this.dischargeArmorValue) {
                            Helpers.teleportEntity(mop.field_72308_g, this.targetTpPoint);
                        } else if (GraviSuite.isSimulating()) {
                            EntityClientPlayerMP senderPlayer = (EntityClientPlayerMP)this.ownerEntity;
                            ServerProxy.sendClientLocalizedMessage(player, this.ownerEntity.func_70005_c_() + " {message.itemRelocator.text.messageToTarget}");
                            ElectricItem.manager.discharge(itemstack, this.dischargeArmorValue, Integer.MAX_VALUE, true, false, false);
                        }
                    } else {
                        Helpers.teleportEntity(mop.field_72308_g, this.targetTpPoint);
                    }
                } else {
                    Helpers.teleportEntity(mop.field_72308_g, this.targetTpPoint);
                }
            }
        } else if (this.actionType == 1) {
            int curPosX = mop.field_72311_b;
            int curPosY = mop.field_72312_c;
            int curPosZ = mop.field_72309_d;
            switch (mop.field_72310_e) {
                case 0: {
                    --curPosY;
                    break;
                }
                case 1: {
                    ++curPosY;
                    break;
                }
                case 2: {
                    --curPosZ;
                    break;
                }
                case 3: {
                    ++curPosZ;
                    break;
                }
                case 4: {
                    --curPosX;
                    break;
                }
                case 5: {
                    ++curPosX;
                }
            }
            if (GraviSuite.isSimulating()) {
                try {
                    TileEntity tileEntity;
                    this.field_70170_p.func_147468_f(curPosX, curPosY, curPosZ);
                    this.field_70170_p.func_147449_b(curPosX, curPosY, curPosZ, (Block)Items.blockRelocatorPortal);
                    this.field_70170_p.func_147471_g(curPosX, curPosY, curPosZ);
                    MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
                    WorldServer targetServer = minecraftserver.func_71218_a(this.targetTpPoint.dimID);
                    targetServer.field_73059_b.func_73158_c((int)this.targetTpPoint.x >> 4, (int)this.targetTpPoint.z >> 4);
                    Block block = targetServer.func_147439_a((int)this.targetTpPoint.x, (int)this.targetTpPoint.y, (int)this.targetTpPoint.z);
                    if (!(block instanceof BlockRelocatorPortal)) {
                        targetServer.func_147449_b((int)this.targetTpPoint.x, (int)this.targetTpPoint.y, (int)this.targetTpPoint.z, (Block)Items.blockRelocatorPortal);
                        targetServer.func_147471_g((int)this.targetTpPoint.x, (int)this.targetTpPoint.y, (int)this.targetTpPoint.z);
                    }
                    if ((tileEntity = targetServer.func_147438_o((int)this.targetTpPoint.x, (int)this.targetTpPoint.y, (int)this.targetTpPoint.z)) instanceof TileEntityRelocatorPortal) {
                        ItemRelocator.TeleportPoint tmpPoint = new ItemRelocator.TeleportPoint();
                        tmpPoint.dimID = this.field_70170_p.field_73011_w.field_76574_g;
                        tmpPoint.x = curPosX;
                        tmpPoint.y = curPosY;
                        tmpPoint.z = curPosZ;
                        ((TileEntityRelocatorPortal)tileEntity).setParentPortal(tmpPoint);
                    }
                    TileEntity currentTileEntity = this.field_70170_p.func_147438_o(curPosX, curPosY, curPosZ);
                    if (tileEntity instanceof TileEntityRelocatorPortal) {
                        ((TileEntityRelocatorPortal)currentTileEntity).setParentPortal(this.targetTpPoint);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }
}

