/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviSuite;
import gravisuite.ServerProxy;
import gravisuite.keyboard.Keyboard;
import gravisuite.utils.NBTHelper;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemAdvancedNightvisionGoggles
extends ItemArmor
implements IElectricItem,
IMetalArmor,
ISpecialArmor {
    private final double maxCharge = 1000000.0;

    public ItemAdvancedNightvisionGoggles(ItemArmor.ArmorMaterial armorMaterial, int renderType, int armorType) {
        super(armorMaterial, renderType, armorType);
        this.func_77637_a(GraviSuite.graviSuiteCreativeTab);
        this.func_77656_e(27);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iIconRegister) {
        this.field_77791_bV = iIconRegister.func_94245_a("gravisuite:itemAdvancedNightvisionGoggles");
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "gravisuite:textures/armor/armor_advanced_nightvision.png";
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.epic;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (world.field_72995_K) {
            return;
        }
        NBTTagCompound nbtData = NBTHelper.getOrCreateNbtData(itemStack);
        boolean active = nbtData.func_74767_n("active");
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        if (!world.field_72995_K && Keyboard.isAltKeyDown(player) && Keyboard.isModeKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            active = !active;
            nbtData.func_74757_a("active", active);
            if (active) {
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.GREEN + "{message.nightvision.enabled}");
            } else {
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.RED + "{message.nightvision.disabled}");
            }
        }
        if (!world.field_72995_K && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        if (active && !world.field_72995_K && ElectricItem.manager.use(itemStack, 1.0, (EntityLivingBase)player)) {
            player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 300, 0, true));
            player.field_71069_bz.func_75142_b();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        info.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.getTier(itemStack));
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return 2;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return 500.0;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    public boolean isMetalArmor(ItemStack itemStack, EntityPlayer entityPlayer) {
        return true;
    }
}

