/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviSuite;
import gravisuite.ServerProxy;
import gravisuite.keyboard.Keyboard;
import gravisuite.utils.NBTHelper;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2Potion;
import ic2.core.Ic2Items;
import ic2.core.item.ItemTinCan;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemAdvancedQuantumHelmet
extends ItemArmor
implements ISpecialArmor,
IElectricItem,
IMetalArmor {
    private final Map<Integer, Integer> potionRemovalCostMap = new HashMap<Integer, Integer>();
    private final double damageAbsorptionRatio = 1.0;
    private final double baseAbsorptionRatio = 0.15;
    public int maxCharge = 10000000;
    public int energyPerDamage = 20000;

    public ItemAdvancedQuantumHelmet(ItemArmor.ArmorMaterial armorMaterial, int render, int armorType) {
        super(armorMaterial, render, armorType);
        this.potionRemovalCostMap.put(Potion.field_76436_u.field_76415_H, 10000);
        this.potionRemovalCostMap.put(IC2Potion.radiation.field_76415_H, 10000);
        this.potionRemovalCostMap.put(Potion.field_82731_v.field_76415_H, 25000);
        this.func_77637_a(GraviSuite.graviSuiteCreativeTab);
        this.func_77656_e(27);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iIconRegister) {
        this.field_77791_bV = iIconRegister.func_94245_a("gravisuite:itemAdvancedQuantumHelmet");
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "gravisuite:textures/armor/armor_graviChestPlate.png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (world.field_72995_K) {
            return;
        }
        NBTTagCompound nbtData = NBTHelper.getOrCreateNbtData(itemStack);
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean ret = false;
        int air = player.func_70086_ai();
        if (!world.field_72995_K && ElectricItem.manager.canUse(itemStack, 1000.0) && air < 100) {
            player.func_70050_g(air + 200);
            ElectricItem.manager.use(itemStack, 1000.0, null);
            ret = true;
        }
        if (ElectricItem.manager.canUse(itemStack, 1000.0) && player.func_71024_bL().func_75121_c()) {
            int foodSlotId = -1;
            for (int hubmode = 0; hubmode < player.field_71071_by.field_70462_a.length; ++hubmode) {
                if (player.field_71071_by.field_70462_a[hubmode] == null || player.field_71071_by.field_70462_a[hubmode].func_77973_b() != Ic2Items.filledTinCan.func_77973_b()) continue;
                foodSlotId = hubmode;
                break;
            }
            if (foodSlotId > -1) {
                ItemStack foodStack = player.field_71071_by.field_70462_a[foodSlotId];
                ItemTinCan tinCanItem = (ItemTinCan)foodStack.func_77973_b();
                foodStack = tinCanItem.onEaten(player, foodStack);
                if (foodStack.field_77994_a <= 0) {
                    player.field_71071_by.field_70462_a[foodSlotId] = null;
                }
                if (!world.field_72995_K) {
                    ElectricItem.manager.use(itemStack, 1000.0, null);
                }
                ret = true;
            }
        }
        if (!world.field_72995_K) {
            for (Object objectEffect : new LinkedList(player.func_70651_bq())) {
                PotionEffect potionEffect = (PotionEffect)objectEffect;
                int potionID = potionEffect.func_76456_a();
                Integer potionRemovalCost = this.potionRemovalCostMap.get(potionID);
                if (potionRemovalCost == null || !ElectricItem.manager.canUse(itemStack, (double)(potionRemovalCost = Integer.valueOf(potionRemovalCost * (potionEffect.func_76458_c() + 1))).intValue())) continue;
                ElectricItem.manager.use(itemStack, (double)potionRemovalCost.intValue(), null);
                player.func_82170_o(potionID);
            }
        }
        boolean nightvision = nbtData.func_74767_n("Nightvision");
        if (!world.field_72995_K && Keyboard.isAltKeyDown(player) && Keyboard.isModeKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            nightvision = !nightvision;
            nbtData.func_74757_a("Nightvision", nightvision);
            if (nightvision) {
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.GREEN + "{message.nightvision.enabled}");
            } else {
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.RED + "{message.nightvision.disabled}");
            }
        }
        if (!world.field_72995_K && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        if (nightvision && !world.field_72995_K && ElectricItem.manager.use(itemStack, 1.0, (EntityLivingBase)player)) {
            player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 300, 0, true));
            ret = true;
        }
        if (!world.field_72995_K && ret) {
            player.field_71069_bz.func_75142_b();
        }
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        info.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.getTier(itemStack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.epic;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return 4;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return 4000.0;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        double absorptionRatio = this.baseAbsorptionRatio * this.damageAbsorptionRatio;
        int energyPerDamage = this.energyPerDamage;
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (!entity.field_70170_p.field_72995_K) {
            ElectricItem.manager.discharge(stack, (double)(damage * this.energyPerDamage), Integer.MAX_VALUE, true, false, false);
        }
    }

    public boolean isMetalArmor(ItemStack itemStack, EntityPlayer entityPlayer) {
        return true;
    }
}

