/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviSuite;
import gravisuite.ServerProxy;
import gravisuite.keyboard.Keyboard;
import gravisuite.utils.Helpers;
import gravisuite.utils.NBTHelper;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemGraviChestPlate
extends ItemArmor
implements IElectricItem,
IMetalArmor,
ISpecialArmor {
    public static int maxCharge;
    public static int minCharge;
    public static int transferLimit;
    public static int tier;
    public static int dischargeInFlight;
    public static int dischargeIdleMode;
    public static float boostSpeed;
    public static int boostMultiplier;
    private static double hoverModeFallSpeed;

    public ItemGraviChestPlate(ItemArmor.ArmorMaterial armorMaterial, int par3, int par4) {
        super(armorMaterial, par3, par4);
        maxCharge = 30000000;
        transferLimit = 60000;
        tier = 4;
        minCharge = 10000;
        dischargeInFlight = 278;
        dischargeIdleMode = 1;
        boostSpeed = 0.2f;
        boostMultiplier = 3;
        this.func_77637_a(GraviSuite.graviSuiteCreativeTab);
        this.func_77656_e(27);
    }

    public static int switchWorkMode(EntityPlayer player, ItemStack itemstack) {
        if (ItemGraviChestPlate.readWorkMode(itemstack)) {
            ItemGraviChestPlate.saveWorkMode(itemstack, false);
            ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.YELLOW + "{message.graviChestPlate.levitationMode} " + EnumChatFormatting.RED + "{message.text.disabled}");
        } else {
            ItemGraviChestPlate.saveWorkMode(itemstack, true);
            ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.YELLOW + "{message.graviChestPlate.levitationMode} " + EnumChatFormatting.GREEN + "{message.text.enabled}");
        }
        return 0;
    }

    public static int switchFlyState(EntityPlayer player, ItemStack itemstack) {
        if (ItemGraviChestPlate.readFlyStatus(itemstack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75100_b = false;
            }
            ItemGraviChestPlate.saveFlyStatus(itemstack, false);
            ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.RED + "{message.graviChestPlate.gravitationEngine} {message.text.disabled}");
        } else {
            int currCharge = ItemGraviChestPlate.getCharge(itemstack);
            if (currCharge < minCharge && !player.field_71075_bZ.field_75098_d) {
                ServerProxy.sendClientLocalizedMessage(player, "{message.graviChestPlate.lowEnergy}");
            } else {
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.GREEN + "{message.graviChestPlate.gravitationEngine} {message.text.enabled}");
                player.field_71075_bZ.field_75101_c = true;
                player.field_71075_bZ.field_75100_b = true;
                ItemGraviChestPlate.saveFlyStatus(itemstack, true);
            }
        }
        return 0;
    }

    public static boolean firstLoadServer(EntityPlayer player, ItemStack itemstack) {
        return true;
    }

    public static int getCharge(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = NBTHelper.getOrCreateNbtData(itemstack);
        return nbttagcompound.func_74762_e("charge");
    }

    public static void setCharge(ItemStack itemstack, int newCharge) {
        NBTTagCompound nbttagcompound = NBTHelper.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74768_a("charge", newCharge);
        System.out.println(newCharge);
    }

    public static boolean readWorkMode(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = NBTHelper.getOrCreateNbtData(itemstack);
        return Minecraft.func_71410_x().func_71356_B() ? nbttagcompound.func_74767_n("isLevitationActive") : nbttagcompound.func_74767_n("hoverMode");
    }

    public static boolean saveWorkMode(ItemStack itemstack, boolean workMode) {
        NBTTagCompound nbttagcompound = NBTHelper.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74757_a("isLevitationActive", workMode);
        return true;
    }

    public static boolean readFlyStatus(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = NBTHelper.getOrCreateNbtData(itemstack);
        return Minecraft.func_71410_x().func_71356_B() ? nbttagcompound.func_74767_n("isFlyActive") : nbttagcompound.func_74767_n("jetpack");
    }

    public static boolean saveFlyStatus(ItemStack itemstack, boolean flyMode) {
        NBTTagCompound nbttagcompound = NBTHelper.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74757_a("isFlyActive", flyMode);
        return true;
    }

    public static boolean readActiveByModStatus(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = NBTHelper.getOrCreateNbtData(itemstack);
        return nbttagcompound.func_74767_n("isFlyActiveByMod");
    }

    public static boolean saveActiveByModStatus(ItemStack itemstack, boolean activeByMod) {
        NBTTagCompound nbttagcompound = NBTHelper.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74757_a("isFlyActiveByMod", activeByMod);
        return true;
    }

    public void onArmorTick(World worldObj, EntityPlayer player, ItemStack itemStack) {
        if (GraviSuite.proxy.checkLastUndressed(player)) {
            GraviSuite.proxy.setLastUndressed(player, Boolean.FALSE);
        }
        if (ItemGraviChestPlate.readFlyStatus(itemStack)) {
            if (!GraviSuite.proxy.checkFlyActiveByMod(player)) {
                GraviSuite.proxy.SetFlyActiveByMod(player, Boolean.TRUE);
            }
            if (!worldObj.field_72995_K && !player.field_71075_bZ.field_75101_c) {
                player.field_71075_bZ.field_75101_c = true;
                if (!player.field_70122_E) {
                    player.field_71075_bZ.field_75100_b = true;
                }
            }
            if (ItemGraviChestPlate.readWorkMode(itemStack) && !worldObj.field_72995_K && (Keyboard.isJumpKeyDown(player) || player.field_70181_x < -hoverModeFallSpeed && !player.field_70122_E) && !player.field_71075_bZ.field_75100_b) {
                player.field_71075_bZ.field_75100_b = true;
            }
            int currCharge = ItemGraviChestPlate.getCharge(itemStack);
            if (!worldObj.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                if (currCharge < dischargeInFlight) {
                    ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.RED + "{message.graviChestPlate.shutdown}");
                    ItemGraviChestPlate.switchFlyState(player, itemStack);
                } else if (!player.field_70122_E) {
                    ElectricItem.manager.discharge(itemStack, (double)dischargeInFlight, 4, false, false, false);
                } else {
                    ElectricItem.manager.discharge(itemStack, (double)dischargeIdleMode, 4, false, false, false);
                }
            }
            player.field_70143_R = 0.0f;
            if (!player.field_70122_E && player.field_71075_bZ.field_75100_b && Keyboard.isBoostKeyDown(player)) {
                this.boostMode(player, itemStack);
                if (currCharge <= dischargeInFlight * boostMultiplier && !player.field_71075_bZ.field_75098_d) {
                    if (!worldObj.field_72995_K) {
                        ServerProxy.sendClientLocalizedMessage(player, "{message.graviChestPlate.noEnergyToBoost}");
                    }
                } else {
                    if (Keyboard.isJumpKeyDown(player)) {
                        player.field_70181_x += (double)(boostSpeed + 0.1f);
                    }
                    if (Keyboard.isSneakKeyDown(player)) {
                        player.field_70181_x -= (double)(boostSpeed + 0.1f);
                    }
                    if (!worldObj.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                        ElectricItem.manager.discharge(itemStack, (double)(dischargeInFlight * boostMultiplier), 3, true, false, false);
                    }
                }
            }
        } else if (!worldObj.field_72995_K && GraviSuite.proxy.checkFlyActiveByMod(player)) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75100_b = false;
            }
            if (GraviSuite.isSimulating()) {
                GraviSuite.proxy.SetFlyActiveByMod(player, Boolean.FALSE);
            }
        }
        if (player.func_70027_ad()) {
            player.func_70066_B();
        }
    }

    public boolean boostMode(EntityPlayer player, ItemStack itemstack) {
        int currCharge;
        if (ItemGraviChestPlate.readFlyStatus(itemstack) && !player.field_70122_E && player.field_71075_bZ.field_75100_b && !player.func_70090_H() && ((currCharge = ItemGraviChestPlate.getCharge(itemstack)) > dischargeInFlight * boostMultiplier || player.field_71075_bZ.field_75098_d)) {
            player.func_70060_a(player.field_70702_br, player.field_70701_bs, boostSpeed);
            if (!player.field_70170_p.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                ElectricItem.manager.discharge(itemstack, (double)(dischargeInFlight * boostMultiplier), 3, true, false, false);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        String gravitationEngine = ItemGraviChestPlate.readFlyStatus(itemStack) ? EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.on") : EnumChatFormatting.DARK_RED + Helpers.formatMessage("message.text.off");
        String levitationModeStatus = ItemGraviChestPlate.readWorkMode(itemStack) ? EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.on") : EnumChatFormatting.DARK_RED + Helpers.formatMessage("message.text.off");
        list.add(EnumChatFormatting.RED + Helpers.formatMessage("message.graviChestPlate.gravitationEngine") + ": " + gravitationEngine);
        list.add(EnumChatFormatting.RED + Helpers.formatMessage("message.graviChestPlate.levitationMode") + ": " + levitationModeStatus);
        list.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.getTier(itemStack));
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public int getEnergyPerDamage() {
        return 20000;
    }

    public double getDamageAbsorptionRatio() {
        return 1.1;
    }

    private double getBaseAbsorptionRatio() {
        return 0.4;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("gravisuite:itemGraviChestPlate");
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "gravisuite:textures/armor/armor_graviChestPlate.png";
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return transferLimit;
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (!entity.field_70170_p.field_72995_K) {
            ElectricItem.manager.discharge(stack, (double)(damage * this.getEnergyPerDamage()), Integer.MAX_VALUE, true, false, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.epic;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }
}

