/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.item;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.Config;
import gravisuite.EntityPlasmaBall;
import gravisuite.GraviSuite;
import gravisuite.ServerProxy;
import gravisuite.keyboard.Keyboard;
import gravisuite.utils.Helpers;
import gravisuite.utils.NBTHelper;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemRelocator
extends ItemTool
implements IElectricItem {
    public static final int maxPoints = 10;
    public static final String nbt_tpList_name = "nbt_tpList_name";
    public static final String nbt_tpList_dimID = "nbt_tpList_dimID";
    public static final String nbt_tpList_pointName = "nbt_tpList_pointName";
    public static final String nbt_tpList_xPos = "nbt_tpList_xPos";
    public static final String nbt_tpList_yPos = "nbt_tpList_yPos";
    public static final String nbt_tpList_zPos = "nbt_tpList_zPos";
    public static final String nbt_tpList_yaw = "nbt_tpList_yaw";
    public static final String nbt_tpList_pitch = "nbt_tpList_pitch";
    public static final String nbt_tpList_defPoint = "nbt_tpList_defPoint";
    private final double maxCharge = 1.0E7;
    private final int tier = 3;
    private final int transferLimit = 50000;
    private final int energyPerStandartTp = Config.relocatorEnergyPerStandartTp;
    private final int energyPerDimensionTp = Config.relocatorEnergyPerDimensionTp;
    private final int energyPerPortal = Config.relocatorEnergyPerPortal;
    private final int energyPerShoot = Config.relocatorEnergyPerTranslocator;

    protected ItemRelocator(Item.ToolMaterial toolMaterial) {
        super(0.0f, toolMaterial, new HashSet());
        this.func_77637_a(GraviSuite.graviSuiteCreativeTab);
        this.func_77656_e(27);
    }

    public static List<TeleportPoint> loadTeleportPoints(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        NBTTagList list = itemStack.field_77990_d.func_150295_c(nbt_tpList_name, 10);
        ArrayList tpList = Lists.newArrayList();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            TeleportPoint newPoint = new TeleportPoint();
            NBTTagCompound loadedPoint = list.func_150305_b(i);
            newPoint.pointName = loadedPoint.func_74779_i(nbt_tpList_pointName);
            newPoint.dimID = loadedPoint.func_74762_e(nbt_tpList_dimID);
            newPoint.x = loadedPoint.func_74769_h(nbt_tpList_xPos);
            newPoint.y = loadedPoint.func_74769_h(nbt_tpList_yPos);
            newPoint.z = loadedPoint.func_74769_h(nbt_tpList_zPos);
            newPoint.yaw = loadedPoint.func_74769_h(nbt_tpList_yaw);
            newPoint.pitch = loadedPoint.func_74769_h(nbt_tpList_pitch);
            newPoint.defPoint = loadedPoint.func_74767_n(nbt_tpList_defPoint);
            tpList.add(newPoint);
        }
        return tpList;
    }

    public static void saveTeleportPoints(ItemStack itemStack, List<TeleportPoint> tpList) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        NBTTagList nbtList = new NBTTagList();
        for (TeleportPoint point : tpList) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a(nbt_tpList_pointName, point.pointName);
            nbt.func_74768_a(nbt_tpList_dimID, point.dimID);
            nbt.func_74780_a(nbt_tpList_xPos, point.x);
            nbt.func_74780_a(nbt_tpList_yPos, point.y);
            nbt.func_74780_a(nbt_tpList_zPos, point.z);
            nbt.func_74780_a(nbt_tpList_yaw, point.yaw);
            nbt.func_74780_a(nbt_tpList_pitch, point.pitch);
            nbt.func_74757_a(nbt_tpList_defPoint, point.defPoint);
            nbtList.func_74742_a((NBTBase)nbt);
        }
        itemStack.func_77978_p().func_74782_a(nbt_tpList_name, (NBTBase)nbtList);
    }

    public static void addNewTeleportPoint(EntityPlayer player, ItemStack itemStack, TeleportPoint newPoint) {
        if (itemStack != null && newPoint != null) {
            ArrayList tpList = Lists.newArrayList();
            tpList.addAll(ItemRelocator.loadTeleportPoints(itemStack));
            if (tpList.size() >= 10) {
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.RED + "{message.itemRelocator.text.memoryFull}");
            } else {
                boolean pointExists = false;
                for (TeleportPoint point : tpList) {
                    if (!point.pointName.equalsIgnoreCase(newPoint.pointName)) continue;
                    ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.YELLOW + newPoint.pointName + " " + EnumChatFormatting.RED + "{message.itemRelocator.text.pointExists}");
                    return;
                }
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.YELLOW + newPoint.pointName + " " + EnumChatFormatting.GREEN + "{message.itemRelocator.text.pointAdded}");
                tpList.add(newPoint);
                ItemRelocator.saveTeleportPoints(itemStack, tpList);
            }
        }
    }

    public static TeleportPoint getDefaultPoint(ItemStack itemStack) {
        TeleportPoint point;
        if (itemStack == null) {
            return null;
        }
        ArrayList tpList = Lists.newArrayList();
        tpList.addAll(ItemRelocator.loadTeleportPoints(itemStack));
        Iterator var2 = tpList.iterator();
        do {
            if (!var2.hasNext()) {
                return null;
            }
            point = (TeleportPoint)var2.next();
        } while (!point.defPoint);
        return point;
    }

    public static Boolean setDefaultPoint(EntityPlayer player, ItemStack itemStack, String ptName) {
        if (itemStack == null) {
            return Boolean.FALSE;
        }
        ArrayList tpList = Lists.newArrayList();
        tpList.addAll(ItemRelocator.loadTeleportPoints(itemStack));
        boolean pointExists = Boolean.FALSE;
        for (TeleportPoint point : tpList) {
            if (point.pointName.equalsIgnoreCase(ptName)) {
                point.defPoint = true;
                pointExists = Boolean.TRUE;
                continue;
            }
            point.defPoint = false;
        }
        if (pointExists) {
            ItemRelocator.saveTeleportPoints(itemStack, tpList);
            ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.WHITE + "{message.itemRelocator.text.defaultPointSet} " + EnumChatFormatting.YELLOW + ptName);
        } else {
            ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.RED + "{message.itemRelocator.text.noPoint}");
        }
        return null;
    }

    public static TeleportPoint getTeleportPointByName(ItemStack itemStack, String ptName) {
        if (itemStack != null && !ptName.equals("")) {
            TeleportPoint point;
            ArrayList tpList = Lists.newArrayList();
            tpList.addAll(ItemRelocator.loadTeleportPoints(itemStack));
            Iterator var3 = tpList.iterator();
            do {
                if (!var3.hasNext()) {
                    return null;
                }
                point = (TeleportPoint)var3.next();
            } while (!point.pointName.equalsIgnoreCase(ptName));
            return point;
        }
        return null;
    }

    public static void removeTeleportPoint(ItemStack itemStack, String tpName) {
        if (itemStack != null) {
            ArrayList tpList = Lists.newArrayList();
            tpList.addAll(ItemRelocator.loadTeleportPoints(itemStack));
            for (int i = 0; i < tpList.size(); ++i) {
                TeleportPoint tmpPoint = (TeleportPoint)tpList.get(i);
                if (!tmpPoint.pointName.equalsIgnoreCase(tpName)) continue;
                tpList.remove(i);
                ItemRelocator.saveTeleportPoints(itemStack, tpList);
                return;
            }
        }
    }

    private static List getCollidingWorldGeometry(World world, AxisAlignedBB axisalignedbb, Entity entity) {
        ArrayList collidingBoundingBoxes = new ArrayList();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = i1; l1 < j1; ++l1) {
                for (int i2 = k - 1; i2 < l; ++i2) {
                    Block block = world.func_147439_a(k1, i2, l1);
                    if (block == null) continue;
                    block.func_149743_a(world, k1, i2, l1, axisalignedbb, collidingBoundingBoxes, entity);
                }
            }
        }
        return collidingBoundingBoxes;
    }

    public static Integer readToolMode(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = NBTHelper.getOrCreateNbtData(itemstack);
        int toolMode = nbttagcompound.func_74762_e("toolMode");
        if (toolMode < 0 || toolMode > 3) {
            toolMode = 0;
        }
        return toolMode;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (Keyboard.isModeKeyDown(player)) {
            if (world.field_72995_K) {
                return itemStack;
            }
            Integer toolMode = ItemRelocator.readToolMode(itemStack);
            if ((toolMode = Integer.valueOf(toolMode + 1)) > 2) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            if (toolMode == 0) {
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.GREEN + "{message.text.mode}: {message.itemRelocator.mode.personal}");
            }
            if (toolMode == 1) {
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.GOLD + "{message.text.mode}: {message.itemRelocator.mode.translocator}");
            }
            if (toolMode == 2) {
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.AQUA + "{message.text.mode}: {message.itemRelocator.mode.portal}");
            }
            return itemStack;
        }
        Integer toolMode = ItemRelocator.readToolMode(itemStack);
        if (player.func_70093_af()) {
            if (toolMode != 1 && toolMode != 2) {
                player.openGui((Object)GraviSuite.instance, 1, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            } else {
                player.openGui((Object)GraviSuite.instance, 3, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
        } else if (toolMode == 0) {
            player.openGui((Object)GraviSuite.instance, 2, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        } else if (!(world.field_72995_K || toolMode != 1 && toolMode != 2)) {
            TeleportPoint tpPoint = ItemRelocator.getDefaultPoint(itemStack);
            if (tpPoint != null) {
                byte launchType;
                int energyPerOperation;
                if (toolMode == 1) {
                    energyPerOperation = this.energyPerShoot;
                    launchType = 0;
                    if (Config.disableRelocatorTranslocator) {
                        ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.RED + "{message.itemRelocator.text.modeTranslocatorDisabled}");
                        return itemStack;
                    }
                } else {
                    energyPerOperation = this.energyPerPortal;
                    launchType = 1;
                    if (Config.disableRelocatorPortal) {
                        ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.RED + "{message.itemRelocator.text.modePortalDisabled}");
                        return itemStack;
                    }
                }
                if (!ElectricItem.manager.canUse(itemStack, (double)energyPerOperation) && !player.field_71075_bZ.field_75098_d) {
                    ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.RED + "{message.text.noenergy}");
                } else {
                    if (GraviSuite.isSimulating() && !player.field_71075_bZ.field_75098_d) {
                        ElectricItem.manager.use(itemStack, (double)energyPerOperation, (EntityLivingBase)player);
                    }
                    EntityPlasmaBall plasmaBall = new EntityPlasmaBall(world, (EntityLivingBase)player, tpPoint, launchType);
                    if (GraviSuite.isSimulating()) {
                        world.func_72838_d((Entity)plasmaBall);
                    }
                    player.func_71038_i();
                }
            } else {
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.RED + "{message.itemRelocator.text.noDefaultPoint}");
            }
        }
        return itemStack;
    }

    public void teleportPlayer(EntityPlayer player, ItemStack itemStack, String tpName) {
        TeleportPoint point;
        if (itemStack != null && player != null && (point = ItemRelocator.getTeleportPointByName(itemStack, tpName)) != null) {
            int energyPerOperation;
            int currentDim = player.field_70170_p.field_73011_w.field_76574_g;
            boolean changeDim = false;
            if (currentDim == point.dimID) {
                energyPerOperation = this.energyPerStandartTp;
            } else {
                energyPerOperation = this.energyPerDimensionTp;
                changeDim = true;
            }
            if (!ElectricItem.manager.canUse(itemStack, (double)energyPerOperation) && !player.field_71075_bZ.field_75098_d) {
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.RED + "{message.text.noenergy}");
            } else {
                if (GraviSuite.isSimulating() && !player.field_71075_bZ.field_75098_d) {
                    ElectricItem.manager.use(itemStack, (double)energyPerOperation, (EntityLivingBase)player);
                }
                Helpers.teleportEntity((Entity)player, point);
            }
        }
    }

    public void saveToolMode(ItemStack itemstack, Integer toolMode) {
        NBTTagCompound nbttagcompound = NBTHelper.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74768_a("toolMode", toolMode.intValue());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        TeleportPoint tpPoint;
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        Integer toolMode = ItemRelocator.readToolMode(itemStack);
        if (toolMode == 0) {
            list.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.itemRelocator.mode.personal"));
        }
        if (toolMode == 1) {
            list.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.itemRelocator.mode.translocator"));
        }
        if (toolMode == 2) {
            list.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.itemRelocator.mode.portal"));
        }
        if ((tpPoint = ItemRelocator.getDefaultPoint(itemStack)) != null) {
            list.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.itemRelocator.defPoint") + ": " + EnumChatFormatting.WHITE + tpPoint.pointName);
        } else {
            list.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.itemRelocator.defPoint") + ": -");
        }
        list.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.getTier(itemStack));
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("gravisuite:itemRelocator");
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.epic;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public static class TeleportPoint {
        public int dimID;
        public String pointName;
        public double x;
        public double y;
        public double z;
        public double yaw;
        public double pitch;
        public boolean defPoint;
    }
}

