/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.keyboard;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.Config;
import gravisuite.GraviSuite;
import gravisuite.item.ItemAdvancedJetPack;
import gravisuite.item.ItemAdvancedLappack;
import gravisuite.item.Items;
import gravisuite.keyboard.Keyboard;
import gravisuite.network.PacketKeyPress;
import gravisuite.network.PacketKeyboardUpdate;
import gravisuite.utils.Helpers;
import ic2.core.IC2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.config.Configuration;

@SideOnly(value=Side.CLIENT)
public class KeyboardClient
extends Keyboard {
    public static Minecraft mc = FMLClientHandler.instance().getClient();
    public static KeyBinding flyKey = new KeyBinding("gravisuite.keys.fly", 33, "GraviSuite");
    public static KeyBinding displayHUDKey = new KeyBinding("gravisuite.keys.hud", 35, "GraviSuite");
    public static int icBoostKeyID;
    public static int icAltKeyID;
    public static int icModeKeyID;
    public static float moveStrafe;
    public static float moveForward;
    private static int lastKeyState;
    private static boolean lastKeyModeState;

    public static void registerKeys() {
        ClientRegistry.registerKeyBinding((KeyBinding)flyKey);
        ClientRegistry.registerKeyBinding((KeyBinding)displayHUDKey);
    }

    public static void keyFlyPressed() {
        if (KeyboardClient.mc.field_71415_G) {
            ItemStack itemstack = KeyboardClient.mc.field_71439_g.field_71071_by.func_70440_f(2);
            if (itemstack != null && itemstack.func_77973_b() == Items.graviChestPlate) {
                PacketKeyPress.issue(1);
            }
            if (itemstack != null && (itemstack.func_77973_b() == Items.advJetpack || itemstack.func_77973_b() == Items.advNanoChestPlate)) {
                PacketKeyPress.issue(1);
            }
        }
    }

    public static void keyHudDisplayPressed() {
        ItemStack itemstack;
        if (KeyboardClient.mc.field_71415_G && (itemstack = KeyboardClient.mc.field_71439_g.field_71071_by.func_70440_f(2)) != null && (itemstack.func_77973_b() == Items.graviChestPlate || itemstack.func_77973_b() instanceof ItemAdvancedJetPack || itemstack.func_77973_b() instanceof ItemAdvancedLappack)) {
            if (KeyboardClient.isAltKeyDown((EntityPlayer)KeyboardClient.mc.field_71439_g)) {
                KeyboardClient.SwitchDisplayHud(Boolean.FALSE);
            } else {
                KeyboardClient.SwitchDisplayHud(Boolean.TRUE);
            }
        }
    }

    public static boolean isBoostKeyDown(EntityPlayer player) {
        return IC2.keyboard.isBoostKeyDown(player);
    }

    public static boolean isAltKeyDown(EntityPlayer player) {
        return IC2.keyboard.isAltKeyDown(player);
    }

    public static boolean isModeKeyPress(EntityPlayer player) {
        if (IC2.keyboard.isModeSwitchKeyDown(player)) {
            if (!lastKeyModeState) {
                lastKeyModeState = true;
                KeyboardClient.sendModeKey(player);
            }
            return true;
        }
        lastKeyModeState = false;
        return false;
    }

    public static boolean isJumpKeyDown(EntityPlayer player) {
        return KeyboardClient.mc.field_71474_y.field_74314_A.func_151470_d();
    }

    public static boolean isForwardKeyDown(EntityPlayer player) {
        return KeyboardClient.mc.field_71474_y.field_74351_w.func_151470_d();
    }

    public static boolean isSneakKeyDown(EntityPlayer player) {
        return KeyboardClient.mc.field_71474_y.field_74311_E.func_151470_d();
    }

    public static void sendModeKey(EntityPlayer player) {
        PacketKeyPress.issue(2);
    }

    public static void updatePlayerMove() {
        moveStrafe = 0.0f;
        moveForward = 0.0f;
        if (KeyboardClient.mc.field_71474_y.field_74351_w.func_151470_d()) {
            moveForward += 1.0f;
        }
        if (KeyboardClient.mc.field_71474_y.field_74368_y.func_151470_d()) {
            moveForward -= 1.0f;
        }
        if (KeyboardClient.mc.field_71474_y.field_74370_x.func_151470_d()) {
            moveStrafe += 1.0f;
        }
        if (KeyboardClient.mc.field_71474_y.field_74366_z.func_151470_d()) {
            moveStrafe -= 1.0f;
        }
        if (KeyboardClient.mc.field_71474_y.field_74311_E.func_151470_d()) {
            moveStrafe = (float)((double)moveStrafe * 0.3);
            moveForward = (float)((double)moveForward * 0.3);
        }
    }

    public static void SwitchDisplayHud(Boolean onOffHud) {
        Configuration tmpConfig = new Configuration(GraviSuite.configFile);
        try {
            tmpConfig.load();
            if (onOffHud.booleanValue()) {
                if (Config.displayHud) {
                    Config.displayHud = false;
                    tmpConfig.get("Hud settings", "Display hud", false).set(false);
                    KeyboardClient.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "[GraviSuite] " + Helpers.formatMessage("message.hud.displayHud") + ": " + EnumChatFormatting.RED + Helpers.formatMessage("message.text.disabled")));
                } else {
                    Config.displayHud = true;
                    tmpConfig.get("Hud settings", "Display hud", true).set(true);
                    KeyboardClient.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "[GraviSuite] " + Helpers.formatMessage("message.hud.displayHud") + ": : " + EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.enabled")));
                }
            } else if (Config.displayHud) {
                int tmpHudPos = Config.hudPos;
                if (++tmpHudPos > 4) {
                    tmpHudPos = 1;
                }
                String HudPosString = "";
                switch (tmpHudPos) {
                    case 1: {
                        HudPosString = Helpers.formatMessage("message.hud.location.topLeft");
                        break;
                    }
                    case 2: {
                        HudPosString = Helpers.formatMessage("message.hud.location.topRight");
                        break;
                    }
                    case 3: {
                        HudPosString = Helpers.formatMessage("message.hud.location.bottomLeft");
                        break;
                    }
                    case 4: {
                        HudPosString = Helpers.formatMessage("message.hud.location.bottomRight");
                    }
                }
                Config.hudPos = tmpHudPos;
                tmpConfig.get("Hud settings", "hudPosition", tmpHudPos).set(tmpHudPos);
                KeyboardClient.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "[GraviSuite] " + Helpers.formatMessage("message.hud.location") + ": " + EnumChatFormatting.AQUA + HudPosString));
            }
        }
        catch (Exception var7) {
            GraviSuite.addLog("Error while loading config file: " + var7);
            throw new RuntimeException(var7);
        }
        finally {
            tmpConfig.save();
        }
    }

    @Override
    public void sendKeyUpdate(EntityPlayer player) {
        int currentKeyState = (KeyboardClient.isBoostKeyDown(player) ? 1 : 0) | (KeyboardClient.isAltKeyDown(player) ? 1 : 0) << 1 | (KeyboardClient.isModeKeyPress(player) ? 1 : 0) << 2 | (KeyboardClient.isForwardKeyDown(player) ? 1 : 0) << 3 | (KeyboardClient.isJumpKeyDown(player) ? 1 : 0) << 4 | (KeyboardClient.isSneakKeyDown(player) ? 1 : 0) << 5;
        if (currentKeyState != lastKeyState) {
            if (Minecraft.func_71410_x().func_71356_B()) {
                PacketKeyboardUpdate.issue(currentKeyState);
            }
            lastKeyState = currentKeyState;
            super.processKeyUpdate(player, currentKeyState);
        }
    }

    static {
        lastKeyState = 0;
        lastKeyModeState = false;
    }
}

