/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.redpower;

import java.util.Comparator;
import net.minecraft.tileentity.TileEntity;

public class WorldCoord
implements Comparable {
    public int x;
    public int y;
    public int z;

    public WorldCoord(int var1, int var2, int var3) {
        this.x = var1;
        this.y = var2;
        this.z = var3;
    }

    public WorldCoord(TileEntity var1) {
        this.x = var1.field_145851_c;
        this.y = var1.field_145848_d;
        this.z = var1.field_145849_e;
    }

    public static int getRightDir(int var0) {
        if (var0 < 2) {
            return var0;
        }
        switch (var0) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 3;
            }
        }
        return 2;
    }

    public static int getIndStepDir(int var0, int var1) {
        switch (var0) {
            case 0: {
                return var1 + 2;
            }
            case 1: {
                return var1 + 2;
            }
            case 2: {
                return var1 + (var1 & 2);
            }
            case 3: {
                return var1 + (var1 & 2);
            }
            case 4: {
                return var1;
            }
        }
        return var1;
    }

    public static Comparator getCompareDir(int dir) {
        return new WCComparator(dir, null);
    }

    public WorldCoord copy() {
        return new WorldCoord(this.x, this.y, this.z);
    }

    public WorldCoord coordStep(int var1) {
        switch (var1) {
            case 0: {
                return new WorldCoord(this.x, this.y - 1, this.z);
            }
            case 1: {
                return new WorldCoord(this.x, this.y + 1, this.z);
            }
            case 2: {
                return new WorldCoord(this.x, this.y, this.z - 1);
            }
            case 3: {
                return new WorldCoord(this.x, this.y, this.z + 1);
            }
            case 4: {
                return new WorldCoord(this.x - 1, this.y, this.z);
            }
        }
        return new WorldCoord(this.x + 1, this.y, this.z);
    }

    public void set(WorldCoord var1) {
        this.x = var1.x;
        this.y = var1.y;
        this.z = var1.z;
    }

    public int squareDist(int var1, int var2, int var3) {
        return (var1 - this.x) * (var1 - this.x) + (var2 - this.y) * (var2 - this.y) + (var3 - this.z) * (var3 - this.z);
    }

    public void step(int var1) {
        switch (var1) {
            case 0: {
                --this.y;
                break;
            }
            case 1: {
                ++this.y;
                break;
            }
            case 2: {
                --this.z;
                break;
            }
            case 3: {
                ++this.z;
                break;
            }
            case 4: {
                --this.x;
                break;
            }
            default: {
                ++this.x;
            }
        }
    }

    public void step(int var1, int var2) {
        switch (var1) {
            case 0: {
                this.y -= var2;
                break;
            }
            case 1: {
                this.y += var2;
                break;
            }
            case 2: {
                this.z -= var2;
                break;
            }
            case 3: {
                this.z += var2;
                break;
            }
            case 4: {
                this.x -= var2;
                break;
            }
            default: {
                this.x += var2;
            }
        }
    }

    public void indStep(int var1, int var2) {
        this.step(var1);
        this.step(WorldCoord.getIndStepDir(var1, var2));
    }

    public int hashCode() {
        int var1 = Integer.valueOf(this.x).hashCode();
        int var2 = Integer.valueOf(this.y).hashCode();
        int var3 = Integer.valueOf(this.z).hashCode();
        return var1 + 31 * (var2 + 31 * var3);
    }

    public int compareTo(Object var1) {
        WorldCoord var2 = (WorldCoord)var1;
        return this.x == var2.x ? (this.y == var2.y ? this.z - var2.z : this.y - var2.y) : this.x - var2.x;
    }

    public boolean equals(Object var1) {
        if (!(var1 instanceof WorldCoord)) {
            return false;
        }
        WorldCoord var2 = (WorldCoord)var1;
        return this.x == var2.x && this.y == var2.y && this.z == var2.z;
    }

    public static class WCComparator
    implements Comparator {
        int dir;

        private WCComparator(int var1) {
            this.dir = var1;
        }

        WCComparator(int var1, WorldCoord var2) {
            this(var1);
        }

        public int compare(Object var1, Object var2) {
            WorldCoord var3 = (WorldCoord)var1;
            WorldCoord var4 = (WorldCoord)var2;
            switch (this.dir) {
                case 0: {
                    return var3.y - var4.y;
                }
                case 1: {
                    return var4.y - var3.y;
                }
                case 2: {
                    return var3.z - var4.z;
                }
                case 3: {
                    return var4.z - var3.z;
                }
                case 4: {
                    return var3.x - var4.x;
                }
            }
            return var4.x - var3.x;
        }
    }
}

