/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.utils;

import cpw.mods.fml.common.FMLLog;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;

public class BukkitHelper {
    public static boolean isBukkitServer = false;
    private static Method getBukkitItemStack;
    private static List<RegisteredListener> playerInteractEventListeners;

    public static boolean canInteract(EntityPlayer player, net.minecraft.item.ItemStack stack, int x, int y, int z, ForgeDirection side) {
        if (!isBukkitServer) {
            return true;
        }
        try {
            Player bukkitPlayer = BukkitHelper.toBukkitPlayer(player);
            PlayerInteractEvent event = new PlayerInteractEvent(bukkitPlayer, Action.RIGHT_CLICK_BLOCK, BukkitHelper.toBukkitItemStack(stack), bukkitPlayer.getWorld().getBlockAt(x, y, z), BukkitHelper.toBukkitFace(side));
            BukkitHelper.callEvent((Event)event);
            return !event.isCancelled();
        }
        catch (Exception e) {
            FMLLog.getLogger().info("Failed to call PlayerInteractEvent: [Player: %s, Item: %s, X:%d, Y:%d, Z:%d, Side: %s]", new Object[]{player.getDisplayName(), stack.func_82833_r(), x, y, z, String.valueOf(side)});
            e.printStackTrace();
            return true;
        }
    }

    private static ArrayList<RegisteredListener> getListenersForEvent(String eventName) {
        ArrayList<RegisteredListener> list = new ArrayList<RegisteredListener>();
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            for (RegisteredListener listener : HandlerList.getRegisteredListeners((Plugin)plugin)) {
                for (Method method : listener.getListener().getClass().getMethods()) {
                    if (!method.isAnnotationPresent(EventHandler.class)) continue;
                    for (Parameter parameter : method.getParameters()) {
                        if (!parameter.getType().getName().equals(eventName)) continue;
                        list.add(listener);
                    }
                }
            }
        }
        return list;
    }

    private static Player toBukkitPlayer(EntityPlayer player) throws Exception {
        return Bukkit.getServer().getPlayer(player.func_110124_au());
    }

    private static void callEvent(Event event) {
        for (RegisteredListener listener : playerInteractEventListeners) {
            try {
                listener.callEvent(event);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private static BlockFace toBukkitFace(ForgeDirection direction) {
        switch (direction) {
            case UP: {
                return BlockFace.UP;
            }
            case DOWN: {
                return BlockFace.DOWN;
            }
            case SOUTH: {
                return BlockFace.SOUTH;
            }
            case NORTH: {
                return BlockFace.NORTH;
            }
            case WEST: {
                return BlockFace.WEST;
            }
            case EAST: {
                return BlockFace.EAST;
            }
        }
        return BlockFace.SELF;
    }

    private static ItemStack toBukkitItemStack(net.minecraft.item.ItemStack stack) throws Exception {
        return (ItemStack)getBukkitItemStack.invoke(null, stack);
    }

    static {
        playerInteractEventListeners = new ArrayList<RegisteredListener>();
        try {
            getBukkitItemStack = Class.forName("org.bukkit.craftbukkit.v1_7_R4.inventory.CraftItemStack").getDeclaredMethod("asCraftMirror", net.minecraft.item.ItemStack.class);
            getBukkitItemStack.setAccessible(true);
            playerInteractEventListeners = BukkitHelper.getListenersForEvent("org.bukkit.event.player.PlayerInteractEvent");
            isBukkitServer = true;
        }
        catch (Exception ex) {
            isBukkitServer = false;
        }
        FMLLog.getLogger().info("Bukkit server " + (isBukkitServer ? "" : "not ") + "found!");
    }
}

