/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.interfaces.INBTStorageClass;

public class DataStoreManager {
    private String dataStoreName;
    private File saveFile = null;
    private Map<INBTStorageClass, String> storageClasses = new HashMap<INBTStorageClass, String>();

    public DataStoreManager(String dataStoreName) {
        this.dataStoreName = dataStoreName;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void addStorageClass(INBTStorageClass theClass, String tagName) {
        this.storageClasses.put(theClass, tagName);
    }

    private void getDataFile() {
        File worldConfig = DimensionManager.getCurrentSaveRootDirectory();
        File hardcoreWitherFolder = new File(worldConfig.getPath(), "HardcoreWither");
        if (!hardcoreWitherFolder.isDirectory() && !hardcoreWitherFolder.mkdir()) {
            HardcoreWither.logger.error("Failed to create " + hardcoreWitherFolder.getAbsolutePath() + " data will not save");
        } else {
            this.saveFile = new File(hardcoreWitherFolder, this.dataStoreName + ".dat");
            try {
                if (!this.saveFile.exists() && !this.saveFile.createNewFile()) {
                    HardcoreWither.logger.error("Failed to create " + this.saveFile.getAbsolutePath() + " data will not save");
                    this.saveFile = null;
                } else {
                    HardcoreWither.logger.debug("Data file: " + this.saveFile.getAbsolutePath() + " found/created");
                }
            }
            catch (IOException e) {
                HardcoreWither.logger.error("Failed to create " + this.saveFile.getAbsolutePath() + " data will not save");
                this.saveFile = null;
            }
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (event.world.field_73011_w.field_76574_g != 0 || event.world.field_72995_K) {
            return;
        }
        if (this.saveFile == null) {
            HardcoreWither.logger.error("Cannot save data");
        } else {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.saveFile);
                NBTTagCompound globalNbt = new NBTTagCompound();
                Iterator<INBTStorageClass> iter = this.storageClasses.keySet().iterator();
                while (iter.hasNext()) {
                    NBTTagCompound classNbt = new NBTTagCompound();
                    INBTStorageClass theClass = iter.next();
                    theClass.writeToNBT(classNbt);
                    globalNbt.func_74782_a(this.storageClasses.get(theClass), (NBTBase)classNbt);
                }
                CompressedStreamTools.func_74799_a((NBTTagCompound)globalNbt, (OutputStream)fileOutputStream);
                HardcoreWither.logger.debug("Saved data");
                fileOutputStream.close();
            }
            catch (Throwable e) {
                HardcoreWither.logger.error("Error saving data: " + e.getLocalizedMessage());
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.field_73011_w.field_76574_g != 0 || event.world.field_72995_K) {
            return;
        }
        if (this.saveFile != null) {
            for (INBTStorageClass starageClass : this.storageClasses.keySet()) {
                starageClass.resetNBT();
            }
            this.saveFile = null;
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.field_73011_w.field_76574_g != 0 || event.world.field_72995_K) {
            return;
        }
        this.getDataFile();
        if (this.saveFile == null) {
            HardcoreWither.logger.error("Cannot load data");
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.saveFile);
                NBTTagCompound globalNbt = CompressedStreamTools.func_74796_a((InputStream)fileInputStream);
                for (INBTStorageClass theClass : this.storageClasses.keySet()) {
                    theClass.readFromNBT(globalNbt.func_74775_l(this.storageClasses.get(theClass)));
                }
                HardcoreWither.logger.debug("Data loaded");
                fileInputStream.close();
            }
            catch (IOException e) {
                HardcoreWither.logger.warn("Failed to  load data " + e.getLocalizedMessage() + ", hopefully a new world.");
            }
        }
    }
}

