/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.config.ConfigManager;
import thor12022.hardcorewither.handlers.PlayerHandler;
import thor12022.hardcorewither.powerUps.PowerUpManager;
import thor12022.hardcorewither.util.TextHelper;

public class EventHandler {
    private PlayerHandler playerHandler;
    private PowerUpManager powerUpManager;

    public EventHandler(PlayerHandler playerHandler, PowerUpManager powerUpManager) {
        this.playerHandler = playerHandler;
        this.powerUpManager = powerUpManager;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals("hardcorewither")) {
            ConfigManager.getInstance().syncConfig();
            HardcoreWither.logger.info(TextHelper.localize("info.hardcorewither.console.config.refresh"));
        }
    }

    @SubscribeEvent
    public void onSpawnMob(EntityJoinWorldEvent event) {
        EntityWither theWither;
        if (!event.world.field_72995_K && event.entity != null && event.entity.getClass() == EntityWither.class && !this.powerUpManager.isWitherPoweredUp(theWither = (EntityWither)event.entity)) {
            List nearbyPlayers = theWither.field_70170_p.func_72872_a(EntityPlayer.class, theWither.field_70121_D.func_72314_b(64.0, 64.0, 64.0));
            if (nearbyPlayers.size() > 0) {
                double powerUpSize = 0.0;
                for (int index = 0; index < nearbyPlayers.size(); ++index) {
                    EntityPlayer player = (EntityPlayer)nearbyPlayers.get(index);
                    powerUpSize += this.playerHandler.wasAtWitherSpawn(player);
                }
                this.powerUpManager.powerUpWither(theWither, (int)Math.round(powerUpSize));
            } else {
                this.powerUpManager.powerUpWither(theWither, -1);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entityLiving != null && event.entityLiving.getClass() == EntityWither.class) {
            this.powerUpManager.update((EntityWither)event.entityLiving);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityDieing(LivingDropsEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entityLiving != null && event.entityLiving.getClass() == EntityWither.class) {
            this.powerUpManager.witherLootDrops(event);
        }
    }

    @SubscribeEvent
    public void onEntityDieing(LivingDeathEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entityLiving != null && event.entityLiving.getClass() == EntityWither.class) {
            this.powerUpManager.witherDied((EntityWither)event.entityLiving);
            List nearbyPlayers = event.entity.field_70170_p.func_72872_a(EntityPlayer.class, event.entity.field_70121_D.func_72314_b(64.0, 64.0, 64.0));
            double powerUpSize = 0.0;
            for (int index = 0; index < nearbyPlayers.size(); ++index) {
                EntityPlayer player = (EntityPlayer)nearbyPlayers.get(index);
                powerUpSize += this.playerHandler.wasAtWitherSpawn(player);
                player.func_145747_a((IChatComponent)new ChatComponentText(TextHelper.localize("info.hardcorewither.chat.wither-experience")));
            }
        }
    }
}

