/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.creativetab.CreativeTabs;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thor12022.hardcorewither.DataStoreManager;
import thor12022.hardcorewither.EventHandler;
import thor12022.hardcorewither.blocks.BlockRecipeRegistry;
import thor12022.hardcorewither.blocks.BlockRegistry;
import thor12022.hardcorewither.client.gui.CreativeTabBaseMod;
import thor12022.hardcorewither.client.gui.GuiHandler;
import thor12022.hardcorewither.command.CommandManager;
import thor12022.hardcorewither.config.ConfigManager;
import thor12022.hardcorewither.entity.EntityRegistry;
import thor12022.hardcorewither.handlers.PlayerHandler;
import thor12022.hardcorewither.handlers.TinkersConstructHandler;
import thor12022.hardcorewither.items.ItemRecipeRegistry;
import thor12022.hardcorewither.items.ItemRegistry;
import thor12022.hardcorewither.potions.PotionRegistry;
import thor12022.hardcorewither.powerUps.PowerUpManager;
import thor12022.hardcorewither.proxies.CommonProxy;
import thor12022.hardcorewither.util.TextHelper;

@Mod(modid="hardcorewither", name="Hardcore Wither", version="1.1.3", dependencies="after:TConstruct")
public class HardcoreWither {
    @SidedProxy(clientSide="thor12022.hardcorewither.proxies.ClientProxy", serverSide="thor12022.hardcorewither.proxies.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs tabBaseMod;
    public static Logger logger;
    @Mod.Instance
    public static HardcoreWither instance;
    private PowerUpManager powerUpManager = new PowerUpManager();
    private PlayerHandler playerHandler = new PlayerHandler();
    private DataStoreManager dataStore = new DataStoreManager("HardcoreWither");
    private EventHandler eventHandler = new EventHandler(this.playerHandler, this.powerUpManager);
    private ItemRegistry itemRegistry = new ItemRegistry();
    private BlockRegistry blockRegistry = new BlockRegistry();
    private PotionRegistry potionRegistry = new PotionRegistry();
    private EntityRegistry entityRegistry = new EntityRegistry();
    private TinkersConstructHandler tiCoRegistry = new TinkersConstructHandler();

    public HardcoreWither() {
        this.dataStore.addStorageClass(this.playerHandler, "PlayerHandler");
        this.dataStore.addStorageClass(this.powerUpManager, "witherData");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger.info(TextHelper.localize("info.hardcorewither.console.load.preInit"));
        this.powerUpManager.init();
        ConfigManager.getInstance().init(event.getSuggestedConfigurationFile());
        this.itemRegistry.registerItems();
        this.blockRegistry.registerBlocks();
        this.potionRegistry.registerPotions();
        this.entityRegistry.register();
        FMLCommonHandler.instance().bus().register((Object)this.eventHandler);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.info(TextHelper.localize("info.hardcorewither.console.load.init"));
        ItemRecipeRegistry.registerItemRecipes();
        BlockRecipeRegistry.registerBlockRecipes();
        if (Loader.isModLoaded((String)"TConstruct")) {
            this.tiCoRegistry.init(event);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        logger.info(TextHelper.localize("info.hardcorewither.console.load.postInit"));
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        CommandManager.serverStarting(event);
    }

    @Mod.EventHandler
    public void onFMLServerStartedEvent(FMLServerStartedEvent event) {
    }

    static {
        tabBaseMod = new CreativeTabBaseMod("hardcorewither.creativeTab");
        logger = LogManager.getLogger((String)"Hardcore Wither");
    }
}

