/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.config;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.Configurable;

public class ConfigManager {
    private static ConfigManager instance = new ConfigManager();
    private ArrayList<Object> configClasses = new ArrayList();
    private Configuration configuration;

    public void init(File config) {
        this.configuration = new Configuration(config);
        this.syncConfig();
    }

    public static ConfigManager getInstance() {
        return instance;
    }

    public void register(Object target) {
        Configurable annotation = target.getClass().getAnnotation(Configurable.class);
        if (annotation != null) {
            this.configClasses.add(target);
        }
    }

    public void syncConfig() {
        if (this.configuration != null) {
            for (Object configClass : this.configClasses) {
                this.processConfigClass(configClass);
            }
            this.configuration.save();
            for (Object configClass : this.configClasses) {
                this.processNotificationClass(configClass);
            }
        }
    }

    private void processConfigClass(Object target) {
        Configurable targetAnnotation = target.getClass().getAnnotation(Configurable.class);
        String sectionName = targetAnnotation.sectionName();
        if (sectionName.isEmpty()) {
            sectionName = target.getClass().getSimpleName();
        }
        this.processClass(sectionName, target, target.getClass());
    }

    private void processNotificationClass(Object target) {
        Configurable targetAnnotation = target.getClass().getAnnotation(Configurable.class);
        String callbackName = targetAnnotation.syncNotification();
        if (!callbackName.isEmpty()) {
            try {
                Method method = target.getClass().getDeclaredMethod(callbackName, new Class[0]);
                method.invoke(target, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void processClass(String sectionName, Object classObj, Class<?> currentClass) {
        if (currentClass == Object.class) {
            return;
        }
        this.processClass(sectionName, classObj, currentClass.getSuperclass());
        for (Field field : currentClass.getDeclaredFields()) {
            Config configAnnotation = field.getAnnotation(Config.class);
            if (configAnnotation == null) continue;
            String fieldName = configAnnotation.fieldName();
            if (fieldName.isEmpty()) {
                fieldName = field.getName();
            }
            try {
                boolean isAccessible = field.isAccessible();
                field.setAccessible(true);
                if (field.getType() == Boolean.TYPE) {
                    field.set(classObj, this.configuration.getBoolean(fieldName, sectionName, field.getBoolean(classObj), configAnnotation.comment()));
                } else if (field.getType() == Float.TYPE) {
                    field.set(classObj, Float.valueOf(this.configuration.getFloat(fieldName, sectionName, field.getFloat(classObj), configAnnotation.minFloat(), configAnnotation.maxFloat(), configAnnotation.comment())));
                } else if (field.getType() == Integer.TYPE) {
                    field.set(classObj, this.configuration.getInt(fieldName, sectionName, field.getInt(classObj), configAnnotation.minInt(), configAnnotation.maxInt(), configAnnotation.comment()));
                } else if (field.getType() == String.class) {
                    field.set(classObj, this.configuration.getString(fieldName, sectionName, (String)field.get(classObj), configAnnotation.comment()));
                } else {
                    this.processClass(sectionName, field.get(classObj), field.getType());
                }
                field.setAccessible(isAccessible);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

