/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.handlers;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.ConfigManager;
import thor12022.hardcorewither.config.Configurable;
import thor12022.hardcorewither.potions.PotionAntiWither;
import thor12022.hardcorewither.potions.PotionRegistry;

@Configurable(sectionName="TinkersConstruct")
public class TinkersConstructHandler {
    @Config
    private static boolean enableGreenHeartCanister = true;
    @Config
    private static boolean enableGreenHeartWitherDrop = true;
    @Config(minInt=0, maxInt=10)
    private static int greenHeartDropRarity = 2;
    private static Item heartCanister = null;

    public TinkersConstructHandler() {
        ConfigManager.getInstance().register(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void init(FMLInitializationEvent event) {
        HardcoreWither.logger.info("Tinkers' Constuct Support Initalizing");
        if (enableGreenHeartCanister) {
            if (heartCanister == null) {
                heartCanister = GameRegistry.findItem((String)"TConstruct", (String)"heartCanister");
            }
            if (heartCanister != null) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(heartCanister, 1, 6), (Object[])new Object[]{new ItemStack(heartCanister, 1, 4), new ItemStack(heartCanister, 1, 5), new ItemStack(Items.field_151156_bN)});
            } else {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                HardcoreWither.logger.warn("Cannot find TConstruct:heartCanister, disabling Tinkers' Construct support");
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        EntityPlayer killerPlayer;
        PotionEffect antiWitherEffect;
        if (!enableGreenHeartWitherDrop || !event.recentlyHit) {
            return;
        }
        if (event.entityLiving != null && event.entityLiving.getClass() == EntityWither.class && event.source.field_76373_n.equals("player") && (antiWitherEffect = (killerPlayer = (EntityPlayer)event.source.func_76346_g()).func_70660_b(PotionRegistry.potionAntiWither)) != null && PotionAntiWither.HasEntityBeenWithered((EntityLivingBase)killerPlayer)) {
            Random rand = new Random();
            int numberOfHearts = 0;
            for (int lootingLevel = event.lootingLevel; lootingLevel > 0; --lootingLevel) {
                numberOfHearts += rand.nextInt(greenHeartDropRarity) == 0 ? 1 : 0;
            }
            EntityItem entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, new ItemStack(heartCanister, numberOfHearts, 5));
            entityitem.field_145804_b = 10;
            event.drops.add(entityitem);
            HardcoreWither.logger.debug("Withered Anti-Withered Player killed Wither, dropping Miniture" + numberOfHearts + " Green Hearts");
        }
    }
}

