/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.potions;

import net.minecraft.potion.Potion;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.ConfigManager;
import thor12022.hardcorewither.config.Configurable;
import thor12022.hardcorewither.potions.PotionAntiWither;

@Configurable
public class PotionRegistry {
    public static Potion potionAntiWither;
    @Config(minInt=24, comment="Ensure this does not get set higher than the size of the potion array")
    private static int antiWitherPotionId;

    public PotionRegistry() {
        ConfigManager.getInstance().register(this);
    }

    public void registerPotions() {
        if (antiWitherPotionId == -1) {
            antiWitherPotionId = PotionRegistry.NextPotionId();
        }
        HardcoreWither.logger.debug("Assigning Potion ID " + antiWitherPotionId + " to Anti-Wither");
        potionAntiWither = new PotionAntiWither(antiWitherPotionId).func_76390_b("potion.antiWither");
    }

    private static int NextPotionId() {
        for (int potionId = 34; potionId < Potion.field_76425_a.length; ++potionId) {
            if (Potion.field_76425_a[potionId] != null) continue;
            return potionId;
        }
        return -1;
    }

    static {
        antiWitherPotionId = 30;
    }
}

