/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.powerUps;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.nbt.NBTTagCompound;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.Configurable;
import thor12022.hardcorewither.powerUps.IPowerUp;
import thor12022.hardcorewither.util.MultiRange;

@Configurable(syncNotification="configChangeNotification")
abstract class AbstractPowerUp
implements IPowerUp {
    protected final EntityWither ownerWither;
    protected final String className = this.getClass().getSimpleName();
    protected int powerStrength;
    @Config
    protected boolean powerUpEnabled = true;
    @Config(minInt=2, comment="The Maximum Strength this Power Up can reach")
    private int maxStrength = 20;
    @Config(minInt=1, comment="The Minimum Wither Level for which this Power Up is available")
    private int minLevel = 1;
    @Config(comment="Dimensions where this Power Up will not be used, e.g. \"-1,0,1-100000\"")
    private String blacklistDims = "";
    private MultiRange blacklistDimsRanges;
    private static Set<String> constructedPrototypeClasses = new HashSet<String>();

    AbstractPowerUp(int minLevel, int maxStrength) {
        this.ownerWither = null;
        this.powerStrength = 0;
        this.maxStrength = maxStrength;
        this.minLevel = minLevel;
        if (constructedPrototypeClasses.contains(this.className)) {
            HardcoreWither.logger.debug("Duplicate Prototype constructed for " + this.className);
        } else {
            constructedPrototypeClasses.add(this.className);
        }
    }

    protected AbstractPowerUp(EntityWither theOwnerWither) {
        this.powerStrength = 1;
        this.ownerWither = theOwnerWither;
    }

    protected boolean isValidApplication(EntityWither theOwnerWither) {
        return this.blacklistDimsRanges != null && !this.blacklistDimsRanges.contains(theOwnerWither.field_71093_bK);
    }

    private void configChangeNotification() {
        this.blacklistDimsRanges = new MultiRange(this.blacklistDims);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("powerStrength", this.powerStrength);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.powerStrength = nbt.func_74762_e("powerStrength");
        this.powerStrength = this.powerStrength <= 0 ? 1 : this.powerStrength;
    }

    @Override
    public boolean increasePower() {
        if (this.powerStrength < this.maxStrength) {
            ++this.powerStrength;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.className;
    }

    @Override
    public int minPower() {
        return this.powerUpEnabled ? this.minLevel : Integer.MAX_VALUE;
    }

    @Override
    public void resetNBT() {
    }
}

