/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.powerUps;

import net.minecraft.entity.boss.EntityWither;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.world.World;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.Configurable;
import thor12022.hardcorewither.powerUps.AbstractPowerUp;

@Configurable
public abstract class AbstractPowerUpMinionSpawner
extends AbstractPowerUp {
    @Config
    public String entityLocalizedName = "Pig";
    @Config(maxInt=65535)
    public int delay = 20;
    @Config(maxInt=65535)
    public int playerRange = 48;
    @Config(maxInt=65535)
    public int maxEntities = 6;
    @Config(maxInt=65535)
    public int minDelay = 600;
    @Config(maxInt=65535)
    public int maxDelay = 800;
    @Config(maxInt=65535)
    public int spawnCount = 4;
    @Config(maxInt=65535)
    public int spawnRange = 4;
    private final WitherMinionSpawner spawner;
    @Config(minFloat=0.0f, maxFloat=10.0f, comment="Amount to increase Spawn Count by. 1.0 to never increase")
    protected static float spawnCountModifier = 1.1f;
    @Config(minFloat=0.0f, maxFloat=1.0f, comment="The smaller it is, the faster the delay decrease. 1.0 to never decrease")
    protected static float spawnDelayModifier = 0.8f;
    @Config(minFloat=1.0f, maxFloat=10.0f, comment="Amount to increase Max Entities by. 1.0 to never increase")
    protected static float maxEntitiesModifier = 1.1f;

    public AbstractPowerUpMinionSpawner(int minLevel, int maxStrength) {
        super(minLevel, maxStrength);
        this.spawner = null;
    }

    protected AbstractPowerUpMinionSpawner(EntityWither theOwnerWither, String entityLocalizedName) {
        super(theOwnerWither);
        this.spawner = new WitherMinionSpawner(this.ownerWither);
        this.entityLocalizedName = entityLocalizedName;
        this.ResetSpawnerToData();
    }

    protected void ResetSpawnerToData() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("EntityId", this.entityLocalizedName);
        nbt.func_74777_a("Delay", (short)this.delay);
        nbt.func_74777_a("RequiredPlayerRange", (short)this.playerRange);
        nbt.func_74777_a("MaxNearbyEntities", (short)this.maxEntities);
        nbt.func_74777_a("MinSpawnDelay", (short)this.minDelay);
        nbt.func_74777_a("MaxSpawnDelay", (short)this.maxDelay);
        nbt.func_74777_a("SpawnCount", (short)this.spawnCount);
        nbt.func_74777_a("SpawnRange", (short)this.spawnRange);
        this.spawner.func_98270_a(nbt);
    }

    @Override
    public void updateWither() {
        this.spawner.func_98278_g();
    }

    @Override
    public boolean increasePower() {
        if (super.increasePower()) {
            this.spawnCount = (int)((float)this.spawnCount * spawnCountModifier);
            this.delay = (int)((float)this.delay * spawnDelayModifier);
            this.minDelay = (int)((float)this.minDelay * spawnDelayModifier);
            this.maxDelay = (int)((float)this.maxDelay * spawnDelayModifier);
            this.maxEntities = (int)((float)this.maxEntities * maxEntitiesModifier);
            this.ResetSpawnerToData();
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.spawnCount = (int)((float)this.spawnCount * (spawnCountModifier * (float)this.powerStrength));
        this.delay = (int)((float)this.delay * (spawnDelayModifier * (float)this.powerStrength));
        this.minDelay = (int)((float)this.minDelay * (spawnDelayModifier * (float)this.powerStrength));
        this.maxDelay = (int)((float)this.maxDelay * (spawnDelayModifier * (float)this.powerStrength));
        this.maxEntities = (int)((float)this.maxEntities * (maxEntitiesModifier * (float)this.powerStrength));
        this.ResetSpawnerToData();
    }

    protected class WitherMinionSpawner
    extends MobSpawnerBaseLogic {
        private final EntityWither ownerWither;

        public WitherMinionSpawner(EntityWither theOwnerWither) {
            this.ownerWither = theOwnerWither;
        }

        public void func_98267_a(int p_98267_1_) {
        }

        public World func_98271_a() {
            return this.ownerWither.field_70170_p;
        }

        public int func_98275_b() {
            return (int)Math.round(this.ownerWither.field_70142_S);
        }

        public int func_98274_c() {
            return (int)Math.round(this.ownerWither.field_70137_T) + 1;
        }

        public int func_98266_d() {
            return (int)Math.round(this.ownerWither.field_70136_U);
        }
    }
}

