/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.powerUps;

import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityWither;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.ConfigManager;
import thor12022.hardcorewither.config.Configurable;
import thor12022.hardcorewither.powerUps.AbstractPowerUp;
import thor12022.hardcorewither.powerUps.IPowerUp;

@Configurable
class PowerUpHealthBoost
extends AbstractPowerUp {
    private static final int DEFAULT_MAX_STRENGTH = 64;
    private static final int DEFAULT_MIN_LEVEL = 3;
    @Config(minFloat=1.0f, maxFloat=10.0f)
    private static float healthBoostMultiplier = 1.1f;

    protected PowerUpHealthBoost() {
        super(3, 64);
        ConfigManager.getInstance().register(this);
    }

    private PowerUpHealthBoost(EntityWither theOwnerWither) {
        super(theOwnerWither);
        this.increasePower();
    }

    @Override
    public IPowerUp createPowerUp(EntityWither theOwnerWither) {
        PowerUpHealthBoost powerUp = new PowerUpHealthBoost(theOwnerWither);
        return powerUp;
    }

    @Override
    public void updateWither() {
        if (!this.ownerWither.field_70170_p.field_72995_K && this.ownerWither.func_82212_n() >= 20) {
            float baseHealth = (float)this.ownerWither.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
            this.ownerWither.func_70691_i((baseHealth * 0.6666667f - 200.0f) / 200.0f);
        }
    }

    @Override
    public void witherDied() {
    }

    @Override
    public boolean increasePower() {
        if (super.increasePower()) {
            double health = this.ownerWither.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
            double newHealth = health * (double)healthBoostMultiplier;
            this.ownerWither.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(newHealth);
            return true;
        }
        return false;
    }
}

