/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.powerUps;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.ConfigManager;
import thor12022.hardcorewither.config.Configurable;
import thor12022.hardcorewither.powerUps.AbstractPowerUp;
import thor12022.hardcorewither.powerUps.IPowerUp;

@Configurable
class PowerUpLightning
extends AbstractPowerUp {
    private static final int DEFAULT_MAX_STRENGTH = 20;
    private static final int DEFAULT_MIN_LEVEL = 1;
    private static final Random random = new Random();
    @Config(minFloat=1.0f, maxFloat=5.0f)
    private static float lightningFrequencyMultiplier = 1.1f;
    @Config(minFloat=1.0f, maxFloat=5.0f, comment="0 is not random, 1 is more random")
    private static float lightningRandomness = 0.5f;
    @Config(minFloat=1.0f, maxFloat=5.0f, comment="Avg number of ticks between lightning")
    private static int lightningFequencyBase = 100;
    @Config(minFloat=0.0f, maxFloat=5.0f, comment="0 is prefect")
    private static float lightningInaccuracy = 0.5f;
    private long lightningNextTick;

    protected PowerUpLightning() {
        super(1, 20);
        ConfigManager.getInstance().register(this);
    }

    private PowerUpLightning(EntityWither theOwnerWither) {
        super(theOwnerWither);
        this.setNextRandomTick();
    }

    private void setNextRandomTick() {
        int strengthBasedTick = (int)((float)lightningFequencyBase / ((float)this.powerStrength * lightningFrequencyMultiplier));
        int modifier = (int)(random.nextGaussian() * (double)lightningRandomness * (double)strengthBasedTick);
        this.lightningNextTick = this.ownerWither.field_70170_p.func_82737_E() + (long)strengthBasedTick + (long)modifier;
    }

    @Override
    public IPowerUp createPowerUp(EntityWither theOwnerWither) {
        PowerUpLightning powerUp = new PowerUpLightning(theOwnerWither);
        return powerUp;
    }

    @Override
    public void updateWither() {
        Entity target;
        int targetId;
        if (this.ownerWither.field_70170_p.func_82737_E() > this.lightningNextTick && (targetId = this.ownerWither.func_82203_t(0)) != -1 && (target = this.ownerWither.field_70170_p.func_73045_a(targetId)) != null) {
            double lightningXPos = target.field_70142_S + 8.0 * random.nextGaussian() * (double)lightningInaccuracy;
            double lightningYPos = target.field_70137_T + 8.0 * random.nextGaussian() * (double)lightningInaccuracy;
            double lightningZPos = target.field_70136_U + 8.0 * random.nextGaussian() * (double)lightningInaccuracy;
            this.ownerWither.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.ownerWither.field_70170_p, lightningXPos, lightningYPos, lightningZPos));
            this.setNextRandomTick();
        }
    }

    @Override
    public void witherDied() {
    }

    @Override
    public boolean increasePower() {
        if (super.increasePower()) {
            this.setNextRandomTick();
            return true;
        }
        return false;
    }
}

