/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.powerUps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.command.AbstractSubCommand;
import thor12022.hardcorewither.command.CommandManager;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.ConfigManager;
import thor12022.hardcorewither.config.Configurable;
import thor12022.hardcorewither.interfaces.INBTStorageClass;
import thor12022.hardcorewither.powerUps.IPowerUp;
import thor12022.hardcorewither.powerUps.PowerUpBlazeMinionSpawner;
import thor12022.hardcorewither.powerUps.PowerUpDeathKnell;
import thor12022.hardcorewither.powerUps.PowerUpGhastMinionSpawner;
import thor12022.hardcorewither.powerUps.PowerUpHealthBoost;
import thor12022.hardcorewither.powerUps.PowerUpLightning;
import thor12022.hardcorewither.powerUps.PowerUpSkeletonMinionSpawner;
import thor12022.hardcorewither.powerUps.PowerUpTeleport;

@Configurable
public class PowerUpManager
implements INBTStorageClass {
    static final int NBT_FORMAT = 1;
    private static final Random RANDOM = new Random();
    private Map<String, IPowerUp> powerUpPrototypes = new HashMap<String, IPowerUp>();
    private Map<UUID, WitherData> activeWitherData = new HashMap<UUID, WitherData>();
    private Map<UUID, NBTTagCompound> savedWitherDataNbt = new HashMap<UUID, NBTTagCompound>();
    private int largestPowerUp = 0;
    @Config(comment="Will enable the Looting enchant on weapons to affect the Wither's drops")
    private boolean witherLooting = true;
    @Config
    private boolean netherStarLooting = true;
    @Config(minFloat=0.0f, comment="Scales the amount of reward in relation to Wither strength (non-linear)")
    private float lootingLevelMultiplier = 2.0f;
    @Config(minFloat=0.0f)
    private float netherStarLootingMultiplier = 0.5f;
    AbstractSubCommand spawnCommand = new AbstractSubCommand(){

        @Override
        public final String func_71518_a(ICommandSender sender) {
            String text = super.func_71518_a(sender);
            Iterator iter = PowerUpManager.this.powerUpPrototypes.keySet().iterator();
            while (iter.hasNext()) {
                text = text + iter.next() + "\n";
            }
            return text;
        }

        public final String func_71517_b() {
            return "spawn";
        }

        @Override
        public void processCommand(ICommandSender sender, String[] args, int startingIndex) {
            if (args.length < startingIndex + 2) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            NBTTagCompound nbt = new NBTTagCompound();
            EntityWither spawnedWither = new EntityWither(sender.func_130014_f_());
            try {
                NBTTagCompound powerUpList = new NBTTagCompound();
                for (int argIndex = startingIndex; argIndex < args.length - 1; argIndex += 2) {
                    String powerUpName = args[argIndex];
                    IPowerUp powerUpPrototype = (IPowerUp)PowerUpManager.this.powerUpPrototypes.get(powerUpName);
                    IPowerUp powerUp = powerUpPrototype.createPowerUp(spawnedWither);
                    for (int powerUpStrength = 1.func_71528_a((ICommandSender)sender, (String)args[argIndex + 1], (int)1); powerUpStrength > 1; --powerUpStrength) {
                        powerUp.increasePower();
                    }
                    NBTTagCompound powerUpNbt = new NBTTagCompound();
                    powerUp.writeToNBT(powerUpNbt);
                    powerUpList.func_74782_a(powerUpName, (NBTBase)powerUpNbt);
                }
                nbt.func_74782_a("powerUps", (NBTBase)powerUpList);
            }
            catch (Exception excp) {
                HardcoreWither.logger.debug("PowerUp Command Formatting Error (probably) not accounted for " + excp);
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            spawnedWither.func_82206_m();
            ChunkCoordinates chunkCoords = sender.func_82114_b();
            spawnedWither.func_70107_b((double)chunkCoords.field_71574_a, (double)chunkCoords.field_71572_b, (double)chunkCoords.field_71573_c);
            PowerUpManager.this.savedWitherDataNbt.put(spawnedWither.func_110124_au(), nbt);
            sender.func_130014_f_().func_72838_d((Entity)spawnedWither);
        }
    };

    public PowerUpManager() {
        CommandManager.getInstance().registerSubCommand(this.spawnCommand);
        ConfigManager.getInstance().register(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void init() {
        this.registerPowerUp(new PowerUpBlazeMinionSpawner());
        this.registerPowerUp(new PowerUpDeathKnell());
        this.registerPowerUp(new PowerUpGhastMinionSpawner());
        this.registerPowerUp(new PowerUpHealthBoost());
        this.registerPowerUp(new PowerUpSkeletonMinionSpawner());
        this.registerPowerUp(new PowerUpLightning());
        this.registerPowerUp(new PowerUpTeleport());
    }

    public void registerPowerUp(IPowerUp powerUp) {
        if (!this.powerUpPrototypes.containsKey(powerUp.getName())) {
            this.powerUpPrototypes.put(powerUp.getName(), powerUp);
            HardcoreWither.logger.info("Registering Prototype for " + powerUp.getName().toString());
        } else {
            HardcoreWither.logger.debug("Duplicate Prototype registered for " + powerUp.getName().toString());
        }
    }

    public void powerUpWither(EntityWither wither, int sizeOfPowerUp) {
        if (this.savedWitherDataNbt.containsKey(wither.func_110124_au())) {
            this.loadWitherFromNBT(wither, this.savedWitherDataNbt.get(wither.func_110124_au()));
            this.savedWitherDataNbt.remove(wither.func_110124_au());
        } else if (!this.activeWitherData.containsKey(wither.func_110124_au())) {
            this.activeWitherData.put(wither.func_110124_au(), new WitherData());
            WitherData witherData = this.activeWitherData.get(wither.func_110124_au());
            int powerUpSize = sizeOfPowerUp != -1 ? sizeOfPowerUp : this.largestPowerUp + 1;
            Collection<IPowerUp> validPowerUpPrototypes = this.powerUpPrototypes.values();
            int usedStrength = 0;
            while (usedStrength < sizeOfPowerUp && validPowerUpPrototypes.size() > 0) {
                IPowerUp powerUpPrototpe = (IPowerUp)validPowerUpPrototypes.toArray()[RANDOM.nextInt(validPowerUpPrototypes.size())];
                if (powerUpPrototpe.minPower() > sizeOfPowerUp) {
                    validPowerUpPrototypes.remove(powerUpPrototpe);
                    continue;
                }
                if (witherData.hasPowerUp(powerUpPrototpe)) {
                    if (witherData.increasePowerUp(powerUpPrototpe)) {
                        ++usedStrength;
                        HardcoreWither.logger.debug("Increasing power of " + powerUpPrototpe.getClass());
                        continue;
                    }
                    validPowerUpPrototypes.remove(powerUpPrototpe);
                    continue;
                }
                IPowerUp newPowerUp = powerUpPrototpe.createPowerUp(wither);
                if (newPowerUp == null) continue;
                witherData.addPowerUp(newPowerUp);
                usedStrength += powerUpPrototpe.minPower() > 0 ? powerUpPrototpe.minPower() : 1;
                HardcoreWither.logger.debug("Adding " + powerUpPrototpe.getName());
            }
            witherData.strength = usedStrength;
            if (powerUpSize > this.largestPowerUp) {
                this.largestPowerUp = powerUpSize;
            }
        } else {
            HardcoreWither.logger.debug("Attempting to re-powerup Wither");
        }
    }

    public void update(EntityWither wither) {
        if (this.activeWitherData.containsKey(wither.func_110124_au())) {
            for (IPowerUp powerUp : this.activeWitherData.get(wither.func_110124_au()).getPowerUps()) {
                powerUp.updateWither();
            }
        }
    }

    public void witherLootDrops(LivingDropsEvent event) {
        WitherData witherData = this.activeWitherData.get(event.entityLiving.func_110124_au());
        if (witherData != null && !witherData.isPendingLootDrops) {
            witherData.isPendingLootDrops = true;
            int lootingLevel = (this.witherLooting ? event.lootingLevel : 0) + (int)Math.round(Math.log10(witherData.strength + 1) * (double)this.lootingLevelMultiplier);
            if (!ForgeHooks.onLivingDrops((EntityLivingBase)event.entityLiving, (DamageSource)event.source, (ArrayList)event.drops, (int)lootingLevel, (boolean)event.recentlyHit, (int)event.specialDropValue)) {
                for (EntityItem item : event.drops) {
                    event.entityLiving.field_70170_p.func_72838_d((Entity)item);
                }
            }
            event.setCanceled(true);
        } else if (witherData != null) {
            witherData.isPendingLootDrops = false;
            if (this.netherStarLooting && event.lootingLevel > 0) {
                int j = 0;
                if ((j = (int)((long)j + Math.round(Math.abs(RANDOM.nextGaussian() * (double)event.lootingLevel * (double)this.netherStarLootingMultiplier)))) > 0) {
                    EntityItem entityItem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, new ItemStack(Items.field_151156_bN, j, 0));
                    entityItem.field_145804_b = 10;
                    event.drops.add(entityItem);
                }
            }
            this.activeWitherData.remove(event.entityLiving.func_110124_au());
        }
    }

    public void witherDied(EntityWither wither) {
        WitherData witherData = this.activeWitherData.get(wither.func_110124_au());
        if (witherData != null) {
            for (IPowerUp powerUp : witherData.getPowerUps()) {
                powerUp.witherDied();
            }
            witherData.hasDied = true;
        }
        this.savedWitherDataNbt.remove(wither.func_110124_au());
    }

    public boolean isWitherPoweredUp(EntityWither wither) {
        return this.activeWitherData.get(wither.func_110124_au()) != null;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound witherListNbt = new NBTTagCompound();
        for (UUID witherUuid : this.activeWitherData.keySet()) {
            NBTTagCompound witherNbt = new NBTTagCompound();
            witherNbt.func_74768_a("totalStrength", this.activeWitherData.get((Object)witherUuid).strength);
            witherNbt.func_74757_a("hasDied", this.activeWitherData.get((Object)witherUuid).hasDied);
            witherNbt.func_74757_a("isPendingLootDrops", this.activeWitherData.get((Object)witherUuid).isPendingLootDrops);
            NBTTagCompound powerUpListNbt = new NBTTagCompound();
            for (IPowerUp powerUp : this.activeWitherData.get(witherUuid).getPowerUps()) {
                String powerUpName = powerUp.getName();
                NBTTagCompound powerUpNbt = new NBTTagCompound();
                powerUp.writeToNBT(powerUpNbt);
                powerUpListNbt.func_74782_a(powerUpName, (NBTBase)powerUpNbt);
            }
            witherNbt.func_74782_a("powerUps", (NBTBase)powerUpListNbt);
            witherListNbt.func_74782_a(witherUuid.toString(), (NBTBase)witherNbt);
        }
        for (UUID witherUuid : this.savedWitherDataNbt.keySet()) {
            witherListNbt.func_74782_a(witherUuid.toString(), (NBTBase)this.savedWitherDataNbt.get(witherUuid));
        }
        nbt.func_74768_a("formatVersion", 1);
        nbt.func_74782_a("witherListNbt", (NBTBase)witherListNbt);
        nbt.func_74768_a("largestPowerUp", this.largestPowerUp);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int formatVersion = nbt.func_74762_e("formatVersion");
        NBTTagCompound witherListNbt = (NBTTagCompound)nbt.func_74781_a("witherListNbt");
        for (String witherUuidString : witherListNbt.func_150296_c()) {
            UUID witherUuid = UUID.fromString(witherUuidString);
            NBTTagCompound witherNbt = (NBTTagCompound)witherListNbt.func_74781_a(witherUuidString);
            if (witherNbt != null) {
                if (formatVersion == 1) {
                    this.savedWitherDataNbt.put(witherUuid, witherNbt);
                    continue;
                }
                NBTTagCompound newWitherNbt = new NBTTagCompound();
                NBTTagCompound powerUpListNbt = new NBTTagCompound();
                for (String powerUpName : witherNbt.func_150296_c()) {
                    powerUpListNbt.func_74782_a(powerUpName, witherNbt.func_74781_a("powerUpName"));
                }
                newWitherNbt.func_74782_a("powerUps", (NBTBase)powerUpListNbt);
                newWitherNbt.func_74768_a("totalStrength", powerUpListNbt.func_150296_c().size());
                newWitherNbt.func_74757_a("hasDied", false);
                newWitherNbt.func_74757_a("isPendingLootDrops", false);
                this.savedWitherDataNbt.put(witherUuid, newWitherNbt);
                continue;
            }
            HardcoreWither.logger.warn("Cannot load Wither for " + witherUuidString);
        }
        this.largestPowerUp = nbt.func_74762_e("largestPowerUp");
    }

    private void loadWitherFromNBT(EntityWither wither, NBTTagCompound nbt) {
        WitherData witherData = new WitherData();
        this.activeWitherData.put(wither.func_110124_au(), witherData);
        witherData.strength = nbt.func_74762_e("totalStrength");
        witherData.hasDied = nbt.func_74767_n("hasDied");
        witherData.isPendingLootDrops = nbt.func_74767_n("pendingDrops");
        NBTTagCompound powerUpList = nbt.func_74775_l("powerUps");
        for (String powerUpName : powerUpList.func_150296_c()) {
            try {
                if (!this.powerUpPrototypes.containsKey(powerUpName)) continue;
                NBTTagCompound powerUpNbt = (NBTTagCompound)powerUpList.func_74781_a(powerUpName);
                IPowerUp powerUp = this.powerUpPrototypes.get(powerUpName).createPowerUp(wither);
                powerUp.readFromNBT(powerUpNbt);
                this.activeWitherData.get(wither.func_110124_au()).addPowerUp(powerUp);
            }
            catch (Exception ex) {
                HardcoreWither.logger.warn("Attempting to powerup from save with unknown powerup: " + powerUpName + "\n\t" + ex);
            }
        }
    }

    @Override
    public void resetNBT() {
        this.activeWitherData.clear();
        this.savedWitherDataNbt.clear();
        this.largestPowerUp = 0;
    }

    private class WitherData {
        ArrayList<IPowerUp> powerUps = new ArrayList();
        int strength = 0;
        boolean hasDied = false;
        boolean isPendingLootDrops = false;

        private WitherData() {
        }

        Collection<IPowerUp> getPowerUps() {
            return this.powerUps;
        }

        boolean increasePowerUp(IPowerUp powerUp) {
            for (IPowerUp usedPowerUp : this.powerUps) {
                if (usedPowerUp.getClass() != powerUp.getClass()) continue;
                return usedPowerUp.increasePower();
            }
            return false;
        }

        boolean hasPowerUp(IPowerUp powerUp) {
            for (IPowerUp usedPowerUp : this.powerUps) {
                if (usedPowerUp.getClass() != powerUp.getClass()) continue;
                return true;
            }
            return false;
        }

        void addPowerUp(IPowerUp powerUp) {
            this.powerUps.add(powerUp);
        }
    }
}

