/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.powerUps;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.ConfigManager;
import thor12022.hardcorewither.config.Configurable;
import thor12022.hardcorewither.powerUps.AbstractPowerUp;
import thor12022.hardcorewither.powerUps.IPowerUp;

@Configurable
class PowerUpTeleport
extends AbstractPowerUp {
    private static final int DEFAULT_MAX_STRENGTH = 20;
    private static final int DEFAULT_MIN_LEVEL = 4;
    private static final Random random = new Random();
    @Config(minFloat=1.0f, maxFloat=10.0f)
    private static float teleportFrequencyMultiplier = 1.1f;
    @Config(minFloat=0.0f, maxFloat=10.0f, comment="0 is not random, 1 is more random")
    private static float teleportRandomness = 0.5f;
    @Config(minInt=20, comment="Avg number of ticks between teleport")
    private static int teleportFequencyBase = 100;
    @Config(minFloat=0.0f, maxFloat=10.0f, comment="0 is prefect")
    private static float teleportInaccuracy = 0.25f;
    private long teleportNextTick;

    protected PowerUpTeleport() {
        super(4, 20);
        ConfigManager.getInstance().register(this);
    }

    private PowerUpTeleport(EntityWither theOwnerWither) {
        super(theOwnerWither);
        this.increasePower();
    }

    @Override
    public IPowerUp createPowerUp(EntityWither theOwnerWither) {
        PowerUpTeleport powerUp = new PowerUpTeleport(theOwnerWither);
        return powerUp;
    }

    @Override
    public void updateWither() {
        Entity target;
        int targetId;
        if (this.ownerWither.func_82212_n() <= 0 && this.ownerWither.field_70170_p.func_82737_E() > this.teleportNextTick && (targetId = this.ownerWither.func_82203_t(0)) != -1 && (target = this.ownerWither.field_70170_p.func_73045_a(targetId)) != null) {
            int retryCount = 0;
            double teleportXPos = 0.0;
            double teleportYPos = 0.0;
            double teleportZPos = 0.0;
            int meanDistance = this.ownerWither.func_70068_e(target) >= 256.0 ? 16 : 8;
            double standardDeviation = 4.0f * teleportInaccuracy;
            do {
                teleportXPos = target.field_70142_S + (double)(meanDistance * (random.nextBoolean() ? 1 : -1)) + standardDeviation * random.nextGaussian();
                teleportYPos = target.field_70137_T + (double)(meanDistance * (random.nextBoolean() ? 1 : -1)) + standardDeviation * random.nextGaussian();
                teleportZPos = target.field_70136_U + (double)(meanDistance * (random.nextBoolean() ? 1 : -1)) + standardDeviation * random.nextGaussian();
                if (!(teleportYPos < 0.0)) continue;
                teleportYPos = 0.0;
            } while (!this.teleportTo(teleportXPos, teleportYPos, teleportZPos) && ++retryCount < 4);
            this.setNextRandomTick();
        }
    }

    protected boolean teleportTo(double x, double y, double z) {
        double oldX = this.ownerWither.field_70165_t;
        double oldY = this.ownerWither.field_70163_u;
        double oldZ = this.ownerWither.field_70161_v;
        this.ownerWither.func_70107_b(x, y, z);
        if (!this.ownerWither.field_70170_p.func_72945_a((Entity)this.ownerWither, this.ownerWither.field_70121_D).isEmpty()) {
            this.ownerWither.func_70107_b(oldX, oldY, oldZ);
            return false;
        }
        this.ownerWither.func_70107_b(this.ownerWither.field_70165_t, this.ownerWither.field_70163_u, this.ownerWither.field_70161_v);
        this.ownerWither.field_70170_p.func_72908_a(oldX, oldY, oldZ, "mob.endermen.portal", 1.0f, 1.0f);
        this.ownerWither.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    @Override
    public void witherDied() {
    }

    @Override
    public boolean increasePower() {
        if (super.increasePower()) {
            this.setNextRandomTick();
            return true;
        }
        return false;
    }

    private void setNextRandomTick() {
        int strengthBasedTick = (int)((float)teleportFequencyBase / ((float)this.powerStrength * teleportFrequencyMultiplier));
        int modifier = (int)(random.nextGaussian() * (double)teleportRandomness * (double)strengthBasedTick);
        this.teleportNextTick = this.ownerWither.field_70170_p.func_82737_E() + (long)strengthBasedTick + (long)modifier;
    }
}

