/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.block;

import chylex.hee.entity.fx.FXType;
import chylex.hee.entity.mob.EntityMobForestGhost;
import chylex.hee.init.ItemList;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C08PlaySound;
import chylex.hee.packets.client.C20Effect;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.MathUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSpookyLog
extends Block {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFace;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;

    public BlockSpookyLog() {
        super(Material.field_151575_d);
        this.func_149675_a(true);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float chance, int fortune) {
        super.func_149690_a(world, x, y, z, meta, chance, fortune);
        if (meta > 0 && !world.field_72995_K && world.field_73012_v.nextInt(4) == 0) {
            EntityPlayer closest = null;
            double curDist = 8.0;
            for (EntityPlayer player : world.field_73010_i) {
                double dist = MathUtil.distance(player.field_70165_t - (double)x, player.field_70161_v - (double)z);
                if (!(dist < curDist)) continue;
                dist = curDist;
                closest = player;
            }
            if (closest != null) {
                boolean foundAmulet = false;
                for (int a = 0; a < closest.field_71071_by.func_70302_i_(); ++a) {
                    ItemStack is = closest.field_71071_by.func_70301_a(a);
                    if (is == null || is.func_77973_b() != ItemList.ghost_amulet || is.func_77960_j() != 1) continue;
                    if (world.field_73012_v.nextInt(5) <= 1) {
                        this.func_149642_a(world, x, y, z, new ItemStack(ItemList.ectoplasm));
                    }
                    PacketPipeline.sendToPlayer(closest, new C08PlaySound(7, closest.field_70165_t, closest.field_70163_u, closest.field_70161_v, 1.8f, 0.9f + world.field_73012_v.nextFloat() * 0.3f));
                    foundAmulet = true;
                    break;
                }
                if (!foundAmulet) {
                    double ang = Math.toRadians((double)closest.field_70177_z + 270.0);
                    EntityMobForestGhost ghost = new EntityMobForestGhost(world, closest);
                    ghost.func_70012_b(closest.field_70165_t + Math.cos(ang) * 3.0, closest.field_70163_u, closest.field_70161_v + Math.sin(ang) * 3.0, 0.0f, 0.0f);
                    world.func_72838_d((Entity)ghost);
                    PacketPipeline.sendToPlayer(closest, new C08PlaySound(5, closest.field_70165_t, closest.field_70163_u, closest.field_70161_v, 1.4f, 1.0f));
                }
            }
        }
        if (!world.field_72995_K && world.field_73012_v.nextInt(8) == 0) {
            this.func_149642_a(world, x, y, z, new ItemStack(ItemList.dry_splinter));
        }
        if (BlockPosM.tmp(x, y + 1, z).getBlock((IBlockAccess)world) == this) {
            this.func_149690_a(world, x, y + 1, z, BlockPosM.tmp(x, y + 1, z).getMetadata((IBlockAccess)world), chance, fortune);
            PacketPipeline.sendToAllAround(world.field_73011_w.field_76574_g, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 64.0, new C20Effect(FXType.Basic.SPOOKY_LOG_DECAY, x, y, z));
            BlockPosM.tmp(x, y + 1, z).setAir(world);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (world.field_72995_K || BlockPosM.tmp(x, y, z).getMetadata((IBlockAccess)world) == 0) {
            return;
        }
        if (rand.nextInt(4) == 0 && !this.isBlockSeen(world, x, y, z)) {
            int w = rand.nextInt(5);
            boolean moved = false;
            BlockPosM pos = new BlockPosM(x, y, z);
            if (w == 0 || w == 1) {
                pos.setMetadata(world, rand.nextInt(4) + 1);
                world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
                moved = true;
            } else if (w == 2) {
                int dir = rand.nextInt(2) * 2 - 1;
                BlockPosM tmpPos = BlockPosM.tmp();
                if (tmpPos.set(x, y + dir, z).getBlock((IBlockAccess)world) == this) {
                    tmpPos.setMetadata(world, pos.getMetadata((IBlockAccess)world));
                    pos.setMetadata(world, 0);
                    world.func_147464_a(x, y + dir, z, (Block)this, this.func_149738_a(world));
                    moved = true;
                }
            } else {
                BlockPosM tmpPos = BlockPosM.tmp();
                for (int attempt = 0; attempt < 50; ++attempt) {
                    if (tmpPos.set(x + rand.nextInt(31) - 15, y, z + rand.nextInt(31) - 15).getBlock((IBlockAccess)world) != this) continue;
                    boolean hasFace = false;
                    int testY = y;
                    while (tmpPos.setY(testY).getBlock((IBlockAccess)world) == this) {
                        if (tmpPos.getMetadata((IBlockAccess)world) > 0) {
                            hasFace = true;
                            break;
                        }
                        ++testY;
                    }
                    testY = y;
                    while (tmpPos.setY(testY).getBlock((IBlockAccess)world) == this) {
                        if (tmpPos.getMetadata((IBlockAccess)world) > 0) {
                            hasFace = true;
                            break;
                        }
                        --testY;
                    }
                    if (hasFace || this.isBlockSeen(world, tmpPos.x, y, tmpPos.z)) continue;
                    tmpPos.setY(y).setMetadata(world, pos.getMetadata((IBlockAccess)world));
                    pos.setMetadata(world, 0);
                    world.func_147464_a(tmpPos.x, tmpPos.y, tmpPos.z, (Block)this, this.func_149738_a(world));
                    moved = true;
                }
            }
            if (moved) {
                if (rand.nextInt(32) == 0) {
                    PacketPipeline.sendToAllAround(world.field_73011_w.field_76574_g, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 64.0, new C08PlaySound(11, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 1.2f + rand.nextFloat() * 0.4f, 0.6f + rand.nextFloat() * 0.5f));
                }
                return;
            }
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        } else {
            world.func_147464_a(x, y, z, (Block)this, 8);
        }
    }

    private boolean isBlockSeen(World world, int x, int y, int z) {
        for (EntityPlayer entity : world.field_73010_i) {
            if (Math.abs(entity.field_70165_t - (double)x) > 250.0 || Math.abs(entity.field_70161_v - (double)z) > 250.0 || !DragonUtil.canEntitySeePoint((EntityLivingBase)entity, x, y, z, 0.5)) continue;
            return true;
        }
        return false;
    }

    public int func_149738_a(World world) {
        return 60;
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return Items.field_151055_y;
    }

    public int func_149745_a(Random rand) {
        return rand.nextInt(4);
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        for (int a = 0; a < 30; ++a) {
            int x = target.field_72311_b;
            int y = target.field_72312_c;
            int z = target.field_72309_d;
            effectRenderer.func_78873_a(new EntityDiggingFX(world, (double)((float)x + world.field_73012_v.nextFloat()), (double)((float)y + world.field_73012_v.nextFloat()), (double)((float)z + world.field_73012_v.nextFloat()), (double)(world.field_73012_v.nextFloat() - 0.5f), 0.0, (double)(world.field_73012_v.nextFloat() - 0.5f), (Block)this, 0).func_70596_a(x, y, z).func_70543_e(0.3f + world.field_73012_v.nextFloat() * 0.6f).func_70541_f(0.2f + world.field_73012_v.nextFloat() * 2.0f));
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        for (int a = 0; a < 90; ++a) {
            effectRenderer.func_78873_a(new EntityDiggingFX(world, (double)((float)x + world.field_73012_v.nextFloat()), (double)((float)y + world.field_73012_v.nextFloat() * 1.5f), (double)((float)z + world.field_73012_v.nextFloat()), (double)(world.field_73012_v.nextFloat() - 0.5f), 0.0, (double)(world.field_73012_v.nextFloat() - 0.5f), (Block)this, 0).func_70596_a(x, y, z).func_70543_e(0.1f + world.field_73012_v.nextFloat() * 0.2f).func_70541_f(world.field_73012_v.nextFloat() * 2.2f));
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffectsCustom(World world, int x, int y, int z) {
        EffectRenderer eff = Minecraft.func_71410_x().field_71452_i;
        for (int a = 0; a < 30; ++a) {
            eff.func_78873_a(new EntityDiggingFX(world, (double)((float)x + world.field_73012_v.nextFloat()), (double)((float)y + world.field_73012_v.nextFloat() * 1.5f), (double)((float)z + world.field_73012_v.nextFloat()), (double)(world.field_73012_v.nextFloat() - 0.5f), 0.0, (double)(world.field_73012_v.nextFloat() - 0.5f), (Block)this, 0).func_70596_a(x, y, z).func_70543_e(0.1f + world.field_73012_v.nextFloat() * 0.2f).func_70541_f(world.field_73012_v.nextFloat() * 2.2f));
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 0 || side == 1 ? this.iconTop : (meta >= 1 && side - 1 == meta ? this.iconFace : this.field_149761_L);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("hardcoreenderexpansion:spooky_log_side");
        this.iconFace = iconRegister.func_94245_a("hardcoreenderexpansion:spooky_log_face");
        this.iconTop = iconRegister.func_94245_a("hardcoreenderexpansion:spooky_log_side");
    }
}

