/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.block.override;

import chylex.hee.system.logging.Log;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.util.Unfinalizer;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;

public class BlockReplaceHelper {
    public static void replaceBlock(Block toReplace, Block replacement) {
        Stopwatch.time("BlockReplace");
        Class[] classTest = new Class[3];
        Exception exception = null;
        try {
            for (Field blockField : Blocks.class.getFields()) {
                Block block;
                if (!Block.class.isAssignableFrom(blockField.getType()) || (block = (Block)blockField.get(null)) != toReplace) continue;
                String registryName = Block.field_149771_c.func_148750_c((Object)block);
                int id = Block.func_149682_b((Block)block);
                Log.debug("Replacing block - $0/$1", id, registryName);
                ((ItemBlock)Item.func_150898_a((Block)block)).field_150939_a = replacement;
                FMLControlledNamespacedRegistry registryBlocks = GameData.getBlockRegistry();
                registryBlocks.field_82596_a.put(registryName, replacement);
                registryBlocks.field_148759_a.func_148746_a((Object)replacement, id);
                blockField.setAccessible(true);
                Unfinalizer.unfinalizeField(blockField);
                blockField.set(null, replacement);
                Method delegateNameMethod = replacement.delegate.getClass().getDeclaredMethod("setName", String.class);
                delegateNameMethod.setAccessible(true);
                delegateNameMethod.invoke((Object)replacement.delegate, toReplace.delegate.name());
                classTest[0] = blockField.get(null).getClass();
                classTest[1] = Block.field_149771_c.func_148754_a(id).getClass();
                classTest[2] = ((ItemBlock)Item.func_150898_a((Block)replacement)).field_150939_a.getClass();
                break;
            }
        }
        catch (Exception e) {
            exception = e;
        }
        Stopwatch.finish("BlockReplace");
        Log.debug("Check field: $0", classTest[0]);
        Log.debug("Check block registry: $0", classTest[1]);
        Log.debug("Check item: $0", classTest[2]);
        if (classTest[0] != classTest[1] || classTest[0] != classTest[2] || classTest[0] == null) {
            throw new RuntimeException("HardcoreEnderExpansion was unable to replace block " + toReplace.func_149739_a() + "! Debug info to report: " + classTest[0] + "," + classTest[1] + "," + classTest[2], exception);
        }
    }
}

