/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.mob.teleport;

import chylex.hee.entity.mob.teleport.ITeleportLocation;
import chylex.hee.system.abstractions.Pos;
import chylex.hee.system.abstractions.Vec;
import chylex.hee.system.util.MathUtil;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.world.IBlockAccess;

public final class TeleportLocation<T extends Entity>
implements ITeleportLocation<T> {
    private final ITeleportXZ<T> findXZ;
    private final ITeleportY<T> findY;

    TeleportLocation(ITeleportXZ<T> findXZ, ITeleportY<T> findY) {
        this.findXZ = findXZ;
        this.findY = findY;
    }

    @Override
    public Vec findPosition(T entity, Vec startPos, Random rand) {
        Vec vec = this.findXZ.findXZ(entity, startPos, rand);
        entity.func_70107_b(vec.x, ((Entity)entity).field_70163_u, vec.z);
        vec.y = this.findY.findY(entity, startPos, rand);
        return vec;
    }

    @FunctionalInterface
    public static interface ITeleportY<T extends Entity> {
        public int findY(T var1, Vec var2, Random var3);

        public static <T extends Entity> ITeleportY<T> around(double maxDist) {
            return (entity, startPos, rand) -> MathUtil.floor(startPos.y + (rand.nextDouble() - 0.5) * 2.0 * maxDist);
        }

        public static <T extends Entity> ITeleportY<T> around(double maxDist, int offset) {
            return (entity, startPos, rand) -> MathUtil.floor(startPos.y + (double)offset + (rand.nextDouble() - 0.5) * 2.0 * maxDist);
        }

        public static <T extends Entity> ITeleportY<T> findSolidBottom(ITeleportY<T> provider, int maxOffset) {
            return (entity, startPos, rand) -> {
                int startY;
                for (int y = startY = provider.findY(entity, startPos, rand); y != startY - maxOffset; y -= (int)Math.signum(maxOffset)) {
                    if (!Pos.at((double)entity.field_70165_t, (double)(y - 1), (double)entity.field_70161_v).getMaterial((IBlockAccess)entity.field_70170_p).func_76230_c()) continue;
                    return y;
                }
                return maxOffset <= 0 ? startY : startY - maxOffset;
            };
        }
    }

    @FunctionalInterface
    public static interface ITeleportXZ<T extends Entity> {
        public Vec findXZ(T var1, Vec var2, Random var3);

        public static <T extends Entity> ITeleportXZ<T> inSquare(double maxDist) {
            return (entity, startPos, rand) -> startPos.offset((rand.nextDouble() - 0.5) * 2.0 * maxDist, 0.0, (rand.nextDouble() - 0.5) * 2.0 * maxDist);
        }

        public static <T extends Entity> ITeleportXZ<T> inCircle(double minDist, double maxDist) {
            return (entity, startPos, rand) -> {
                Vec offXZ = Vec.xzRandom(rand);
                double dist = minDist + rand.nextDouble() * (maxDist - minDist);
                return startPos.offset(offXZ.x * dist, 0.0, offXZ.z * dist);
            };
        }

        public static <T extends Entity> ITeleportXZ<T> exactDistance(double dist) {
            return (entity, startPos, rand) -> {
                Vec offXZ = Vec.xzRandom(rand);
                return startPos.offset(offXZ.x * dist, 0.0, offXZ.z * dist);
            };
        }
    }
}

