/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.handlers;

import chylex.hee.gui.GuiEnderCompendium;
import chylex.hee.gui.helpers.GuiItemRenderHelper;
import chylex.hee.mechanics.compendium.KnowledgeCategories;
import chylex.hee.mechanics.compendium.content.KnowledgeCategory;
import chylex.hee.mechanics.compendium.elements.CompendiumCategoryElement;
import java.util.ArrayList;
import java.util.List;

public final class CompendiumTabHandler {
    private final GuiEnderCompendium gui;
    private final List<CompendiumCategoryElement> categories = new ArrayList<CompendiumCategoryElement>(KnowledgeCategories.list.length);
    private CompendiumCategoryElement selected;
    private int prevOffset = Integer.MIN_VALUE;

    public CompendiumTabHandler(GuiEnderCompendium compendium) {
        this.gui = compendium;
        int tabY = 0;
        for (KnowledgeCategory category : KnowledgeCategories.list) {
            this.categories.add(new CompendiumCategoryElement(category, tabY));
            tabY += 25;
        }
        this.selected = this.categories.get(0);
    }

    public boolean onMouseClick(int mouseX, int mouseY, int mouseButton) {
        for (CompendiumCategoryElement element : this.categories) {
            if (!element.isMouseOver(mouseX, mouseY, element == this.selected)) continue;
            this.selected = element;
            this.gui.moveToObject(element.category.getTargetObj(), true);
            return true;
        }
        return false;
    }

    public void render(int mouseX, int mouseY) {
        int offset = -((int)this.gui.getScrollHandler().getOffset(1.0f));
        if (offset != this.prevOffset && !this.gui.getScrollHandler().isAnimating()) {
            this.prevOffset = offset;
            if (offset < 0) {
                this.selected = this.categories.get(0);
            } else {
                for (CompendiumCategoryElement element : this.categories) {
                    int y = element.category.getTargetObj().getY() - this.gui.field_146295_m / 2;
                    if (offset < y) break;
                    this.selected = element;
                }
            }
        }
        for (CompendiumCategoryElement element : this.categories) {
            element.render(this.gui, element == this.selected);
            if (!element.isMouseOver(mouseX, mouseY, element == this.selected)) continue;
            GuiItemRenderHelper.setupTooltip(mouseX, mouseY, element.category.getTranslatedTooltip());
        }
    }
}

