/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.essence.handler;

import chylex.hee.entity.item.EntityItemAltar;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.enhancements.types.EssenceAltarEnhancements;
import chylex.hee.mechanics.essence.EssenceType;
import chylex.hee.mechanics.essence.handler.AltarActionHandler;
import chylex.hee.mechanics.essence.handler.dragon.AltarItemRecipe;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C11ParticleAltarOrb;
import chylex.hee.system.collections.WeightedList;
import chylex.hee.system.collections.weight.IWeightProvider;
import chylex.hee.system.collections.weight.ObjectWeightPair;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.CollectionUtil;
import chylex.hee.system.util.ItemUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.TileEntityEssenceAltar;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DragonEssenceHandler
extends AltarActionHandler {
    public static final List<AltarItemRecipe> recipes = CollectionUtil.newList(new AltarItemRecipe(new ItemStack(Items.field_151067_bt), new ItemStack(ItemList.enhanced_brewing_stand), 20), new AltarItemRecipe(new ItemStack(Items.field_151061_bv), new ItemStack(ItemList.temple_caller), 50), new AltarItemRecipe(new ItemStack(ItemList.ghost_amulet, 1, 0), new ItemStack(ItemList.ghost_amulet, 1, 1), 8));
    private AxisAlignedBB itemBoundingBox;
    private final List<BlockPosM> pedestals = new ArrayList<BlockPosM>();
    private byte updatePedestalTimer = (byte)2;
    private long pedestalAreaHash;
    private byte lastMaxPedestals;
    private short repairCounter;

    public DragonEssenceHandler(TileEntityEssenceAltar altar) {
        super(altar);
    }

    @Override
    public void onUpdate() {
        this.updatePedestalTimer = (byte)(this.updatePedestalTimer - 1);
        if (this.updatePedestalTimer <= 0) {
            this.updatePedestalTimer = (byte)20;
            byte maxPedestals = this.altar.getEnhancements().contains(EssenceAltarEnhancements.RANGE) ? (byte)12 : 8;
            int range = maxPedestals == 12 ? 4 : 3;
            long currentHash = 0L;
            if (this.lastMaxPedestals != maxPedestals) {
                this.lastMaxPedestals = maxPedestals;
                this.pedestalAreaHash = 0L;
            }
            World world = this.altar.func_145831_w();
            for (int xx = -range; xx <= range; ++xx) {
                for (int zz = -range; zz <= range; ++zz) {
                    int id = Block.func_149682_b((Block)BlockPosM.tmp(this.altar.field_145851_c + xx, this.altar.field_145848_d, this.altar.field_145849_e + zz).getBlock((IBlockAccess)world));
                    currentHash += (long)((4 + xx) * 7 + (4 + zz) + id) * 262144L + (long)(xx * id) + (long)(zz * id);
                }
            }
            if (this.pedestalAreaHash != currentHash) {
                this.pedestalAreaHash = currentHash;
                this.pedestals.clear();
                IdentityHashMap<Block, Byte> blockCounts = new IdentityHashMap<Block, Byte>();
                Block[][] blocks = new Block[range * 2 + 1][range * 2 + 1];
                BlockPosM tmpPos = BlockPosM.tmp();
                for (int xx = this.altar.field_145851_c - range; xx <= this.altar.field_145851_c + range; ++xx) {
                    for (int zz = this.altar.field_145849_e - range; zz <= this.altar.field_145849_e + range; ++zz) {
                        Block block;
                        if (Math.abs(xx - this.altar.field_145851_c) <= 1 && Math.abs(zz - this.altar.field_145849_e) <= 1 || !tmpPos.set(xx, this.altar.field_145848_d + 1, zz).isAir(world) || !tmpPos.set(xx - 1, this.altar.field_145848_d, zz).isAir(world) && DragonEssenceHandler.hasCollisionBox(this.altar, xx - 1, this.altar.field_145848_d, zz) || !tmpPos.set(xx + 1, this.altar.field_145848_d, zz).isAir(world) && DragonEssenceHandler.hasCollisionBox(this.altar, xx + 1, this.altar.field_145848_d, zz) || !tmpPos.set(xx, this.altar.field_145848_d, zz - 1).isAir(world) && DragonEssenceHandler.hasCollisionBox(this.altar, xx, this.altar.field_145848_d, zz - 1) || !tmpPos.set(xx, this.altar.field_145848_d, zz + 1).isAir(world) && DragonEssenceHandler.hasCollisionBox(this.altar, xx, this.altar.field_145848_d, zz + 1) || !DragonEssenceHandler.hasCollisionBox(this.altar, xx, this.altar.field_145848_d, zz) || (block = tmpPos.set(xx, this.altar.field_145848_d, zz).getBlock((IBlockAccess)world)).func_149688_o() == Material.field_151579_a) continue;
                        blocks[range + xx - this.altar.field_145851_c][range + zz - this.altar.field_145849_e] = block;
                        if (blockCounts.containsKey(block)) {
                            blockCounts.put(block, (byte)((Byte)blockCounts.get(block) + 1));
                            continue;
                        }
                        blockCounts.put(block, (byte)1);
                    }
                }
                SortedSet sorted = CollectionUtil.sortMapByValueDesc(blockCounts);
                for (Map.Entry entry : sorted) {
                    if ((Byte)entry.getValue() > maxPedestals) continue;
                    for (int xx = -range; xx <= range; ++xx) {
                        for (int zz = -range; zz <= range; ++zz) {
                            if (blocks[range + xx][range + zz] != entry.getKey()) continue;
                            this.pedestals.add(new BlockPosM(this.altar.field_145851_c + xx, this.altar.field_145848_d, this.altar.field_145849_e + zz));
                        }
                    }
                }
            }
            for (BlockPosM loc : this.pedestals) {
                if (world.field_73012_v.nextInt(5) > 1) continue;
                PacketPipeline.sendToAllAround(this.altar, 64.0, (AbstractPacket)new C11ParticleAltarOrb(this.altar, (double)loc.x + 0.5, (double)this.altar.field_145848_d + 0.5, (double)loc.z + 0.5));
            }
        }
        if (this.itemBoundingBox == null) {
            this.itemBoundingBox = AxisAlignedBB.func_72330_a((double)((double)this.altar.field_145851_c + 0.5 - 4.5), (double)((double)this.altar.field_145848_d + 0.9), (double)((double)this.altar.field_145849_e + 0.5 - 4.5), (double)((double)this.altar.field_145851_c + 0.5 + 4.5), (double)((double)this.altar.field_145848_d + 1.6), (double)((double)this.altar.field_145849_e + 0.5 + 4.5));
        }
        World world = this.altar.func_145831_w();
        List thrownItems = world.func_72872_a(EntityItem.class, this.itemBoundingBox);
        for (EntityItem item : thrownItems) {
            for (BlockPosM loc : this.pedestals) {
                double targX = (double)loc.x + 0.5;
                double targY = (double)loc.y + 1.15;
                double targZ = (double)loc.z + 0.5;
                if (Math.abs(item.field_70165_t - targX) > 0.001 || Math.abs(item.field_70163_u - targY) > 0.001 || Math.abs(item.field_70161_v - targZ) > 0.001) {
                    if (!world.func_72872_a(EntityItemAltar.class, AxisAlignedBB.func_72330_a((double)targX, (double)targY, (double)targZ, (double)targX, (double)targY, (double)targZ)).isEmpty() || !(Math.sqrt(MathUtil.square(targX - item.field_70165_t) + MathUtil.square(targY - item.field_70163_u) + MathUtil.square(targZ - item.field_70161_v)) < 0.275)) continue;
                    world.func_72838_d((Entity)new EntityItemAltar(world, targX, targY, targZ, item, EssenceType.DRAGON.id));
                    continue;
                }
                if ((this.updatePedestalTimer & 3) != 1 || !(item instanceof EntityItemAltar)) continue;
                EntityItemAltar altarItem = (EntityItemAltar)item;
                altarItem.pedestalUpdate = 0;
                if (this.altar.getEssenceLevel() <= 0) continue;
                this.updatePedestalItem(altarItem);
                if (world.field_73012_v.nextInt(5) != 0) continue;
                PacketPipeline.sendToAllAround(this.altar.func_145831_w().field_73011_w.field_76574_g, targX, (double)loc.y + 0.5, targZ, 64.0, new C11ParticleAltarOrb(targX, (double)loc.y + 0.5, targZ, item.field_70165_t, item.field_70163_u + 0.3, item.field_70161_v, this.altar.getEssenceType().id, 1));
            }
        }
    }

    public static boolean hasCollisionBox(TileEntityEssenceAltar altar, int x, int y, int z) {
        Block block = altar.func_145831_w().func_147439_a(x, y, z);
        return block.func_149688_o() == Material.field_151579_a ? false : block.func_149668_a(altar.func_145831_w(), x, y, z) != null;
    }

    private void updatePedestalItem(EntityItemAltar item) {
        block16: {
            ItemStack is;
            List<Enum> enhancements;
            block17: {
                int a;
                enhancements = this.altar.getEnhancements();
                is = item.func_92059_d();
                if (item.field_70170_p.field_73012_v.nextInt(3) == 0) break block17;
                if (!is.func_77984_f() || is.func_77960_j() == 0 || !is.func_77973_b().isRepairable()) break block16;
                int n = a = enhancements.contains(EssenceAltarEnhancements.SPEED) ? 2 : 1;
                while (a > 0) {
                    this.repairCounter = (short)(this.repairCounter + 1);
                    if (this.repairCounter > (enhancements.contains(EssenceAltarEnhancements.EFFICIENCY) ? (short)72 : 56)) {
                        this.altar.drainEssence(1);
                        this.repairCounter = 0;
                    }
                    if (this.updateItemCounter(is, "HEE_repair", 1) >= 18) {
                        this.updateItemCounter(is, "HEE_repair", 0);
                        int amount = MathUtil.clamp(MathUtil.floor(Math.sqrt(is.func_77958_k()) * 0.65), 1, is.func_77960_j());
                        is.func_77964_b(is.func_77960_j() - amount);
                        item.hasChanged = true;
                    }
                    --a;
                }
                break block16;
            }
            if (is.func_77948_v() && is.func_77973_b() != Items.field_151134_bR) {
                int b;
                int n = b = enhancements.contains(EssenceAltarEnhancements.SPEED) ? 2 : 1;
                while (b > 0) {
                    if (this.updateItemCounter(is, "HEE_enchant", 1) < 280 - is.func_77973_b().func_77619_b() * 5) {
                        return;
                    }
                    this.updateItemCounter(is, "HEE_enchant", 0);
                    NBTTagList enchants = is.func_77986_q();
                    if (enchants == null || enchants.func_74745_c() == 0) {
                        return;
                    }
                    block2: for (int attempt = 0; attempt < 3; ++attempt) {
                        WeightedList list = new WeightedList((IWeightProvider[])new ObjectWeightPair[0]);
                        for (int a = 0; a < enchants.func_74745_c(); ++a) {
                            Enchantment e = Enchantment.field_77331_b[enchants.func_150305_b(a).func_74765_d("id")];
                            if (e == null) continue;
                            list.add(ObjectWeightPair.of(e, e.func_77324_c()));
                        }
                        if (list.isEmpty()) continue;
                        Enchantment chosenEnchantment = (Enchantment)((ObjectWeightPair)list.getRandomItem(item.field_70170_p.field_73012_v)).getObject();
                        for (int a = 0; a < enchants.func_74745_c(); ++a) {
                            NBTTagCompound tag = enchants.func_150305_b(a);
                            if (tag.func_74765_d("id") != chosenEnchantment.field_77352_x) continue;
                            short level = tag.func_74765_d("lvl");
                            int cost = this.getEnchantmentCost(chosenEnchantment, level + 1);
                            if (enhancements.contains(EssenceAltarEnhancements.EFFICIENCY)) {
                                cost = MathUtil.ceil((float)cost * 0.65f);
                            }
                            if (level >= chosenEnchantment.func_77325_b() || this.altar.getEssenceLevel() < cost) continue;
                            this.altar.drainEssence(cost);
                            tag.func_74777_a("lvl", (short)(level + 1));
                            ItemUtil.getTagRoot(is, true).func_74782_a("ench", (NBTBase)enchants);
                            item.hasChanged = true;
                            attempt = 999;
                            continue block2;
                        }
                    }
                    --b;
                }
            } else if (item.field_70170_p.field_73012_v.nextInt(5) == 0) {
                for (AltarItemRecipe recipe : recipes) {
                    int a;
                    if (!recipe.isApplicable(is)) continue;
                    int n = a = enhancements.contains(EssenceAltarEnhancements.SPEED) ? 2 : 1;
                    while (a > 0) {
                        if (this.updateItemCounter(is, "HEE_transform", 1) > Math.max(MathUtil.ceil((float)recipe.cost * (enhancements.contains(EssenceAltarEnhancements.EFFICIENCY) ? 0.65f : 1.0f)), recipe.cost >> 1)) {
                            this.updateItemCounter(is, "HEE_transform", 0);
                            recipe.doTransaction(item);
                            item.hasChanged = true;
                            break block16;
                        }
                        this.altar.drainEssence(1);
                        --a;
                    }
                    break;
                }
            }
        }
    }

    private int getEnchantmentCost(Enchantment ench, int level) {
        return MathUtil.floor(Math.max(1.0f, 1.0f + 2.0f * (float)level * ((float)level / (float)ench.func_77325_b()) + (float)(10 - ench.func_77324_c()) * 0.2f));
    }

    private short updateItemCounter(ItemStack is, String counterName, int operation) {
        NBTTagCompound nbt = ItemUtil.getTagRoot(is, true);
        if (operation == 0) {
            nbt.func_82580_o(counterName);
            return 0;
        }
        short counter = nbt.func_74765_d(counterName);
        if (operation == 1) {
            counter = (short)(counter + 1);
            nbt.func_74777_a(counterName, counter);
        }
        return counter;
    }

    @Override
    public void onTileWriteToNBT(NBTTagCompound nbt) {
        nbt.func_74777_a("D_repairCnt", this.repairCounter);
    }

    @Override
    public void onTileReadFromNBT(NBTTagCompound nbt) {
        this.repairCounter = nbt.func_74765_d("D_repairCnt");
    }
}

