/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.test.list.system;

import chylex.hee.init.ItemList;
import chylex.hee.system.test.Assert;
import chylex.hee.system.test.data.MethodType;
import chylex.hee.system.test.data.RunTime;
import chylex.hee.system.test.data.UnitTest;
import chylex.hee.system.util.ItemDamagePair;
import chylex.hee.system.util.ItemPattern;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemHandlingTests {
    private final String matchError = "Unexpected matching item list size, expected $2, got $1.";
    private List<ItemStack> patternTestList = new ArrayList<ItemStack>();
    private NBTTagCompound patternTestNbt;

    @UnitTest(type=MethodType.PREPARATION, runTime=RunTime.LOADCOMPLETE)
    public void prepItemPattern() {
        this.patternTestList.add(new ItemStack(Blocks.field_150346_d));
        this.patternTestList.add(new ItemStack(Blocks.field_150346_d, 64));
        this.patternTestList.add(new ItemStack(Blocks.field_150346_d, 1, 2));
        this.patternTestList.add(new ItemStack((Block)Blocks.field_150349_c));
        this.patternTestList.add(new ItemStack(ItemList.adventurers_diary));
        this.patternTestList.add(new ItemStack(ItemList.ghost_amulet, 1, 1));
        this.patternTestNbt = new NBTTagCompound();
        this.patternTestNbt.func_74774_a("testValue", (byte)1);
        this.patternTestList.get(0).func_77982_d(this.patternTestNbt);
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testItemPatternName() {
        Assert.equal(new ItemPattern().setItemName("", "*").retainMatching(this.patternTestList).size(), 6, "Unexpected matching item list size, expected $2, got $1.");
        Assert.equal(new ItemPattern().setItemName("HardcoreEnderExpansion", "*").retainMatching(this.patternTestList).size(), 2, "Unexpected matching item list size, expected $2, got $1.");
        Assert.equal(new ItemPattern().setItemName("minecraft", "dirt").retainMatching(this.patternTestList).size(), 3, "Unexpected matching item list size, expected $2, got $1.");
        Assert.equal(new ItemPattern().setItemName("minecraft", "sand").retainMatching(this.patternTestList).size(), 0, "Unexpected matching item list size, expected $2, got $1.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testItemPatternDamage() {
        Assert.equal(new ItemPattern().setDamageValues(new int[]{1}).retainMatching(this.patternTestList).size(), 1, "Unexpected matching item list size, expected $2, got $1.");
        Assert.equal(new ItemPattern().setDamageValues(new int[]{1, 2}).retainMatching(this.patternTestList).size(), 2, "Unexpected matching item list size, expected $2, got $1.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testItemPatternNBT() {
        Assert.equal(new ItemPattern().setNBT((NBTTagCompound)this.patternTestNbt.func_74737_b()).retainMatching(this.patternTestList).size(), 1, "Unexpected matching item list size, expected $2, got $1.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testItemDamagePair() {
        ItemDamagePair pair1 = new ItemDamagePair(Items.field_151016_H, 0);
        ItemDamagePair pair2 = new ItemDamagePair(Items.field_151016_H, -1);
        String error1 = "Failed item damage pair test (expected true).";
        String error2 = "Failed item damage pair test (expected false).";
        Assert.state(pair1.check(new ItemStack(Items.field_151016_H)), error1);
        Assert.state(!pair1.check(new ItemStack(Items.field_151016_H, 1, 1)), error2);
        Assert.state(pair2.check(new ItemStack(Items.field_151016_H, 1, 1)), error1);
        Assert.state(!pair1.check(new ItemStack(Items.field_151100_aR)), error2);
    }
}

