/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.tileentity;

import chylex.hee.api.interfaces.IAcceptFieryEssence;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.brewing.PotionTypes;
import chylex.hee.mechanics.enhancements.EnhancementEnumHelper;
import chylex.hee.mechanics.enhancements.EnhancementHandler;
import chylex.hee.mechanics.enhancements.IEnhanceableTile;
import chylex.hee.mechanics.enhancements.types.EnhancedBrewingStandEnhancements;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.ItemUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityBrewingStand;

public class TileEntityEnhancedBrewingStand
extends TileEntityBrewingStand
implements IAcceptFieryEssence,
IEnhanceableTile {
    private static final int[] topSlots = new int[]{3};
    private static final int[] sideSlots = new int[]{0, 1, 2};
    private static final int[] bottomSlots = new int[]{4};
    private ItemStack[] slotItems = new ItemStack[5];
    private byte filledSlotsCache;
    private short startBrewTime;
    private short brewTime;
    private short requiredPowder;
    private Item ingredient;
    private List<Enum> enhancements = new ArrayList<Enum>();

    public void func_145845_h() {
        int filledSlots;
        if (!this.field_145850_b.field_72995_K) {
            if (this.brewTime > 0) {
                this.brewTime = (short)(this.brewTime - 1);
                if (this.brewTime > 1 && this.brewTime % 2 == 0 && this.enhancements.contains(EnhancedBrewingStandEnhancements.SPEED)) {
                    this.brewTime = (short)(this.brewTime - 1);
                }
                if (this.brewTime == 0) {
                    this.doBrewing();
                    this.func_70296_d();
                } else if (!this.checkBrewingRequirements() || this.ingredient != this.slotItems[3].func_77973_b()) {
                    this.brewTime = 0;
                    this.func_70296_d();
                }
            } else if (this.checkBrewingRequirements()) {
                this.startBrewTime = this.brewTime = (short)(140 + 15 * this.requiredPowder);
                this.ingredient = this.slotItems[3].func_77973_b();
            }
        }
        if ((filledSlots = this.func_145939_j()) != this.filledSlotsCache) {
            this.filledSlotsCache = (byte)filledSlots;
            BlockPosM.tmp(this.field_145851_c, this.field_145848_d, this.field_145849_e).setMetadata(this.field_145850_b, filledSlots, 2);
        }
    }

    private boolean checkBrewingRequirements() {
        if (this.slotItems[3] == null || this.slotItems[3].field_77994_a == 0) {
            this.requiredPowder = 0;
            return false;
        }
        int potionCount = 0;
        this.requiredPowder = 0;
        for (int a = 0; a < 3; ++a) {
            if (this.slotItems[a] == null) continue;
            potionCount = (byte)(potionCount + 1);
            if (!PotionTypes.canBeApplied(this.slotItems[3], this.slotItems[a], this.enhancements.contains(EnhancedBrewingStandEnhancements.TIER))) {
                return false;
            }
            this.requiredPowder = (short)(this.requiredPowder + PotionTypes.getRequiredPowder(this.slotItems[3].func_77973_b(), this.slotItems[a]));
        }
        this.requiredPowder = (short)Math.min((float)this.requiredPowder * (potionCount == 2 ? 0.835f : (potionCount == 3 ? 0.7f : 1.0f)) * (this.enhancements.contains(EnhancedBrewingStandEnhancements.COST) ? 0.65f : 1.0f), 69.0f);
        if (potionCount == 0) {
            return false;
        }
        return this.requiredPowder == 0 || this.slotItems[4] != null && this.slotItems[4].field_77994_a >= this.requiredPowder;
    }

    private void doBrewing() {
        if (this.field_145850_b.field_72995_K || !this.checkBrewingRequirements()) {
            return;
        }
        for (int a = 0; a < 3; ++a) {
            if (this.slotItems[a] == null) continue;
            this.slotItems[a] = PotionTypes.applyIngredientUnsafe(this.slotItems[3], this.slotItems[a]);
            ItemUtil.getTagRoot(this.slotItems[a], true).func_74757_a("hasPotionChanged", true);
        }
        if (--this.slotItems[3].field_77994_a == 0) {
            this.slotItems[3] = null;
        }
        if (this.requiredPowder > 0) {
            this.slotItems[4].field_77994_a -= this.requiredPowder;
            if (this.slotItems[4].field_77994_a == 0) {
                this.slotItems[4] = null;
            }
            this.requiredPowder = 0;
        }
    }

    @Override
    public List<Enum> getEnhancements() {
        return this.enhancements;
    }

    @Override
    public ItemStack createEnhancedItemStack() {
        return EnhancementHandler.addEnhancements(new ItemStack(ItemList.enhanced_brewing_stand), this.enhancements);
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? super.func_145825_b() : "container.enhancedBrewing";
    }

    public int func_70302_i_() {
        return this.slotItems.length;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return is.func_77973_b() == ItemList.end_powder && slot == 4 || super.func_94041_b(slot, is);
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 0 && slot < this.slotItems.length ? this.slotItems[slot] : null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.func_70304_b(slot);
    }

    public ItemStack func_70304_b(int slot) {
        if (slot >= 0 && slot < this.slotItems.length) {
            ItemStack is = this.slotItems[slot];
            this.slotItems[slot] = null;
            return is;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack is) {
        if (slot >= 0 && slot < this.slotItems.length) {
            this.slotItems[slot] = is;
        }
    }

    public int func_145939_j() {
        int i = 0;
        for (int j = 0; j < 3; ++j) {
            if (this.slotItems[j] == null) continue;
            i |= 1 << j;
        }
        return i;
    }

    public int[] func_94128_d(int side) {
        return side == 1 ? topSlots : (side == 0 ? bottomSlots : sideSlots);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_145938_d(int brewTime) {
        this.brewTime = (short)brewTime;
    }

    @SideOnly(value=Side.CLIENT)
    public void setRequiredPowder(int requiredPowder) {
        this.requiredPowder = (short)requiredPowder;
    }

    @SideOnly(value=Side.CLIENT)
    public void setStartBrewTime(int startBrewTime) {
        this.startBrewTime = (short)startBrewTime;
    }

    public int func_145935_i() {
        return this.brewTime;
    }

    public int getStartBrewTime() {
        return this.startBrewTime;
    }

    public int getRequiredPowder() {
        return this.requiredPowder;
    }

    public int getHoldingPowder() {
        return this.slotItems[4] == null ? 0 : this.slotItems[4].field_77994_a;
    }

    @Override
    public int getBoostAmount(int essenceLevel) {
        return Math.min(this.brewTime - 1, 1 + Math.min(7, essenceLevel >> 6));
    }

    @Override
    public void boost() {
        this.brewTime = (short)(this.brewTime - 1);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList tagItemList = new NBTTagList();
        for (int i = 0; i < this.slotItems.length; ++i) {
            if (this.slotItems[i] == null) continue;
            NBTTagCompound tagSlot = new NBTTagCompound();
            tagSlot.func_74774_a("Slot", (byte)i);
            this.slotItems[i].func_77955_b(tagSlot);
            tagItemList.func_74742_a((NBTBase)tagSlot);
        }
        nbt.func_74782_a("hedItems", (NBTBase)tagItemList);
        nbt.func_74777_a("hedBrewTime", this.brewTime);
        nbt.func_74778_a("enhancements", EnhancementEnumHelper.serialize(this.enhancements));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList tagItemList = nbt.func_150295_c("hedItems", 10);
        this.slotItems = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagItemList.func_74745_c(); ++i) {
            NBTTagCompound tagSlot = tagItemList.func_150305_b(i);
            byte slotId = tagSlot.func_74771_c("Slot");
            if (slotId < 0 || slotId >= this.slotItems.length) continue;
            this.slotItems[slotId] = ItemStack.func_77949_a((NBTTagCompound)tagSlot);
        }
        this.brewTime = nbt.func_74765_d("hedBrewTime");
        this.enhancements = EnhancementEnumHelper.deserialize(nbt.func_74779_i("enhancements"), EnhancedBrewingStandEnhancements.class);
    }
}

