/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.feature.blobs.populators;

import chylex.hee.system.util.MathUtil;
import chylex.hee.world.feature.blobs.BlobPopulator;
import chylex.hee.world.feature.util.DecoratorFeatureGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class BlobPopulatorLake
extends BlobPopulator {
    private Block liquid;
    private double minRadius;
    private double maxRadius;

    public BlobPopulatorLake(int weight) {
        super(weight);
    }

    public BlobPopulatorLake block(Block liquid) {
        this.liquid = liquid;
        return this;
    }

    public BlobPopulatorLake rad(double minRadius, double maxRadius) {
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        return this;
    }

    @Override
    public void generate(DecoratorFeatureGenerator gen, Random rand) {
        int placed = 0;
        for (int attempt = 0; attempt < 90 && placed < 4; ++attempt) {
            int z;
            int x = rand.nextInt(32) - 16;
            int y = gen.getTopBlockY(x, z = rand.nextInt(32) - 16);
            if (y == Integer.MIN_VALUE || gen.getBlock(x, y, z) != Blocks.field_150377_bs || gen.getBlock(x, y + 1, z) != Blocks.field_150350_a) continue;
            double rad = this.minRadius + rand.nextDouble() * (this.maxRadius - this.minRadius);
            int irad = MathUtil.ceil(rad);
            for (int xx = x - irad; xx <= x + irad; ++xx) {
                for (int zz = z - irad; zz <= z + irad; ++zz) {
                    if (gen.getBlock(xx, y, zz) != Blocks.field_150377_bs || gen.getBlock(xx, y + 1, zz) != Blocks.field_150350_a || gen.getBlock(xx - 1, y, zz) == Blocks.field_150350_a || gen.getBlock(xx + 1, y, zz) == Blocks.field_150350_a || gen.getBlock(xx, y, zz - 1) == Blocks.field_150350_a || gen.getBlock(xx, y, zz + 1) == Blocks.field_150350_a || !(MathUtil.distance(xx - x, zz - z) <= rad)) continue;
                    gen.setBlock(xx, y, zz, this.liquid);
                }
            }
            ++placed;
        }
    }
}

