/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome;

import chylex.hee.entity.mob.EntityMobInfestedBat;
import chylex.hee.system.achievements.AchievementManager;
import chylex.hee.world.structure.island.biome.IslandBiomeBase;
import chylex.hee.world.structure.island.biome.data.AbstractBiomeInteraction;
import chylex.hee.world.structure.island.biome.data.BiomeContentVariation;
import chylex.hee.world.structure.island.biome.data.BiomeRandomDeviation;
import chylex.hee.world.structure.island.biome.decorator.BiomeDecoratorInfestedForest;
import chylex.hee.world.structure.island.biome.decorator.IslandBiomeDecorator;
import chylex.hee.world.structure.island.biome.interaction.BiomeInteractionsInfestedForest;
import chylex.hee.world.structure.util.pregen.LargeStructureWorld;
import chylex.hee.world.util.SpawnEntry;
import java.util.Random;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.stats.Achievement;

public class IslandBiomeInfestedForest
extends IslandBiomeBase {
    public static final BiomeContentVariation DEEP = new BiomeContentVariation(0, 8);
    public static final BiomeContentVariation RAVAGED = new BiomeContentVariation(3, 6);
    public static final BiomeContentVariation RUINS = new BiomeContentVariation(4, 3);
    public static final BiomeRandomDeviation TALL_TREES = new BiomeRandomDeviation("TallTrees", DEEP, RAVAGED);
    public static final BiomeRandomDeviation MORE_THORNY_BUSHES = new BiomeRandomDeviation("ThornyBushes", DEEP);
    private final BiomeDecoratorInfestedForest decorator = new BiomeDecoratorInfestedForest();

    protected IslandBiomeInfestedForest(int biomeID) {
        super(biomeID);
        this.contentVariations.add(DEEP);
        this.contentVariations.add(RAVAGED);
        this.randomDeviations.add(TALL_TREES);
        this.randomDeviations.add(MORE_THORNY_BUSHES);
        this.getSpawnEntries(DEEP).addAll(new SpawnEntry[]{new SpawnEntry(EntitySilverfish.class, 35, 35), new SpawnEntry(EntityMobInfestedBat.class, 8, 10)});
        this.getInteractions(DEEP).addAll((AbstractBiomeInteraction.BiomeInteraction[])new AbstractBiomeInteraction.BiomeInteraction[]{new AbstractBiomeInteraction.BiomeInteraction("IF_Deep_CollapsingTrees", BiomeInteractionsInfestedForest.InteractionCollapsingTrees.class, 40, 2)});
    }

    @Override
    public void decorate(LargeStructureWorld world, Random rand, int centerX, int centerZ) {
        if (this.data.content == DEEP) {
            this.decorator.genDeep();
        } else if (this.data.content == RAVAGED) {
            this.decorator.genRavaged();
        } else if (this.data.content == RUINS) {
            this.decorator.genRuins();
        }
    }

    @Override
    public float getIslandSurfaceHeightMultiplier() {
        return this.data.content == RUINS ? 0.9f : 0.7f;
    }

    @Override
    public float getIslandMassHeightMultiplier() {
        return this.data.content == RAVAGED ? 1.15f : 0.95f;
    }

    @Override
    public float getIslandFillFactor() {
        return this.data.content == RAVAGED ? 1.08f : 1.04f;
    }

    @Override
    public float getCaveAmountMultiplier() {
        return this.data.content == RAVAGED ? 0.0f : (this.data.content == RUINS ? 0.85f : 1.15f);
    }

    @Override
    public float getCaveBranchingChance() {
        return this.data.content == RUINS ? 0.035f : 0.026f;
    }

    @Override
    public float getOreAmountMultiplier() {
        return this.data.content == RAVAGED ? 0.6f : 1.0f;
    }

    @Override
    protected IslandBiomeDecorator getDecorator() {
        return this.decorator;
    }

    @Override
    protected Achievement getAchievement() {
        return AchievementManager.BIOME_INFESTED_FOREST;
    }

    @Override
    public int getTopBlockMeta() {
        return 0;
    }
}

