/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.mountains;

import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.structure.island.biome.feature.AbstractIslandStructure;
import chylex.hee.world.util.Direction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;

public class StructureLavaPool
extends AbstractIslandStructure {
    @Override
    protected boolean generate(Random rand) {
        int x = this.getRandomXZ(rand, 12);
        int z = this.getRandomXZ(rand, 12);
        int y = 25 + rand.nextInt(50);
        while (this.world.isAir(x, --y, z) && y > 10) {
        }
        if (this.world.getBlock(x, y, z) != this.surface()) {
            return false;
        }
        HashSet<BlockPosM> lavaBlocks = new HashSet<BlockPosM>();
        int discAmount = 5 + rand.nextInt(8);
        for (int disc = 0; disc < discAmount; ++disc) {
            double len = (0.5 + rand.nextDouble() * 0.5) * (double)disc * 0.75;
            double rad = 1.8 + rand.nextDouble() * 3.0;
            double radSq = MathUtil.square(rad + 0.5);
            float ang = rand.nextFloat() * (float)Math.PI * 2.0f;
            double px = (double)x + (double)MathHelper.func_76134_b((float)ang) * len;
            double pz = (double)z + (double)MathHelper.func_76126_a((float)ang) * len;
            for (int ix = (int)(px - rad) - 1; ix <= (int)(px + rad) + 1; ++ix) {
                for (int iz = (int)(pz - rad) - 1; iz <= (int)(pz + rad) + 1; ++iz) {
                    if (!(MathUtil.square((double)ix - px) + MathUtil.square((double)iz - pz) <= radSq)) continue;
                    lavaBlocks.add(new BlockPosM(ix, y, iz));
                }
            }
        }
        for (BlockPosM lava : lavaBlocks) {
            if (this.world.getBlock(lava.x, lava.y, lava.z) == this.surface() && !this.world.isAir(lava.x, lava.y - 1, lava.z) && !this.world.isAir(lava.x - 1, lava.y, lava.z) && !this.world.isAir(lava.x + 1, lava.y, lava.z) && !this.world.isAir(lava.x, lava.y, lava.z - 1) && !this.world.isAir(lava.x, lava.y, lava.z + 1)) continue;
            return false;
        }
        for (BlockPosM lava : lavaBlocks) {
            this.world.setBlock(lava.x, lava.y, lava.z, Blocks.field_150353_l);
        }
        for (int yOff = 1; yOff < 3 + rand.nextInt(2); ++yOff) {
            for (int pass = 0; pass < 3; ++pass) {
                Iterator iter = lavaBlocks.iterator();
                while (iter.hasNext()) {
                    BlockPosM lava = (BlockPosM)iter.next();
                    if (this.world.isAir(lava.x, lava.y - yOff - 1, lava.z)) {
                        iter.remove();
                        continue;
                    }
                    if (!rand.nextBoolean() && !rand.nextBoolean()) continue;
                    int surrounding = 0;
                    for (int dir = 0; dir < 4; ++dir) {
                        surrounding += this.world.getBlock(lava.x + Direction.offsetX[dir], lava.y, lava.z + Direction.offsetZ[dir]) == Blocks.field_150353_l ? 1 : 0;
                    }
                    if (surrounding > 3) continue;
                    iter.remove();
                }
                for (BlockPosM lava : lavaBlocks) {
                    this.world.setBlock(lava.x, lava.y - yOff, lava.z, Blocks.field_150353_l);
                }
            }
        }
        return true;
    }
}

