/*
 * Decompiled with CFR 0.152.
 */
package highlands;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import fabricator77.multiworld.api.biomeregistry.BoPBiomeSupport;
import fabricator77.multiworld.api.biomeregistry.DerivedBiomeRegistry;
import fabricator77.multiworld.api.biomeregistry.DerivedBiomeRegistryConfig;
import highlands.CommonProxy;
import highlands.Config;
import highlands.HighLandsCreativeTab;
import highlands.HighlandsEventManager;
import highlands.HighlandsFuelHandler;
import highlands.Initializer;
import highlands.MapGenStructureConfig;
import highlands.WorldTypeHighlands;
import highlands.api.HighlandsBiomes;
import highlands.api.HighlandsBlocks;
import highlands.integration.HighlandsCompatibilityManager;
import highlands.integration.MultiWorldSupport;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="Highlands", name="Highlands", version="2.2.3")
public class Highlands {
    public static String modid = "Highlands";
    @Mod.Instance(value="Highlands")
    public static Highlands instance;
    @SidedProxy(clientSide="highlands.CommonProxy", serverSide="highlands.CommonProxy")
    public static CommonProxy proxy;
    public static WorldType HL;
    public static WorldType HLLB;
    public static int HighlandsBiomeSizeDefault;
    public static int HighlandsBiomeSizeLB;
    public static boolean mocreaturescomp;
    public static boolean improvedOceans;
    public static boolean borderBiomeFlag;
    public static boolean skyColorFlag;
    public static boolean vanillaBlocksFlag;
    public static boolean plantsFlag;
    public static int islandRarity;
    public static boolean addBoPbiomes;
    public static boolean useOreGens;
    public static boolean useGenLayers;
    public static CreativeTabs tabHighlands;
    public static DerivedBiomeRegistry derivedBiomeRegistry;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(new File(event.getModConfigurationDirectory() + File.separator + "Highlands" + File.separator + "General.cfg"));
        config.load();
        Config.setUpConfig(config);
        config.save();
        Initializer.constructBlocks();
        Initializer.initRecipes();
        for (Block block : HighlandsBlocks.logs) {
            Initializer.setFireProperties(block, 5, 5);
        }
        for (Block block : HighlandsBlocks.leaves) {
            Initializer.setFireProperties(block, 30, 60);
        }
        for (Block block : HighlandsBlocks.plants) {
            Initializer.setFireProperties(block, 60, 100);
        }
        for (Block block : HighlandsBlocks.planks) {
            Initializer.setFireProperties(block, 5, 20);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        HighlandsBiomes.initBiomeArrays();
        Initializer.constructBiomes();
        Initializer.constructSettings();
        Initializer.setUpAllSubBiomes();
        new MultiWorldSupport();
        if (addBoPbiomes) {
            new BoPBiomeSupport();
        }
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new HighlandsEventManager());
        MinecraftForge.EVENT_BUS.register((Object)new HighlandsEventManager());
        for (BiomeGenBase i : HighlandsBiomes.biomesForDefault) {
            WorldChunkManager.allowedBiomes.add(i);
        }
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        derivedBiomeRegistry = new DerivedBiomeRegistry();
        String configURL = Loader.instance().getConfigDir() + File.separator + "Highlands" + File.separator + "BiomeWeighting.cfg";
        DerivedBiomeRegistryConfig biomeWeighting = new DerivedBiomeRegistryConfig(derivedBiomeRegistry, configURL);
        biomeWeighting.loadConfig();
        biomeWeighting.saveConfig();
        HL = new WorldTypeHighlands("Highlands");
        HLLB = new WorldTypeHighlands("HighlandsLB");
        MapGenStructureConfig.postInit();
        HighlandsCompatibilityManager.registerBiomesForgeBiomeDict();
        GameRegistry.registerFuelHandler((IFuelHandler)new HighlandsFuelHandler());
        if (Loader.isModLoaded((String)"Forestry")) {
            try {
                HighlandsCompatibilityManager.registerBlocksForestry();
                HighlandsCompatibilityManager.registerRecipesForestry();
            }
            catch (Exception e) {
                System.err.println("[Highlands] Failed to enable Forestry compatibility because: ");
                e.printStackTrace();
            }
        }
        if (Loader.isModLoaded((String)"MineFactoryReloaded")) {
            try {
                HighlandsCompatibilityManager.registerBlocksMFR();
            }
            catch (Exception e) {
                System.err.println("[Highlands] Failed to enable MFR compatibility because: ");
                e.printStackTrace();
            }
        }
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            try {
                HighlandsCompatibilityManager.registerBlocksThaumcraft();
            }
            catch (Exception e) {
                System.err.println("[Highlands] Failed to enable Thaumcraft compatibility because: ");
                e.printStackTrace();
            }
        }
    }

    static {
        mocreaturescomp = false;
        improvedOceans = true;
        borderBiomeFlag = true;
        skyColorFlag = false;
        vanillaBlocksFlag = false;
        plantsFlag = true;
        islandRarity = 14;
        addBoPbiomes = false;
        useOreGens = true;
        useGenLayers = true;
        tabHighlands = new HighLandsCreativeTab();
    }
}

