/*
 * Decompiled with CFR 0.152.
 */
package highlands.block;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import highlands.Highlands;
import highlands.api.HighlandsBlocks;
import highlands.worldgen.WorldGenAutumnTree;
import highlands.worldgen.WorldGenHighlandsBigTree;
import highlands.worldgen.WorldGenHighlandsShrub;
import highlands.worldgen.WorldGenTreeAcacia;
import highlands.worldgen.WorldGenTreeAsh;
import highlands.worldgen.WorldGenTreeCanopy;
import highlands.worldgen.WorldGenTreeFir;
import highlands.worldgen.WorldGenTreeIronwood;
import highlands.worldgen.WorldGenTreeMangrove;
import highlands.worldgen.WorldGenTreePalm;
import highlands.worldgen.WorldGenTreePoplar;
import highlands.worldgen.WorldGenTreeRedwood;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import powercrystals.minefactoryreloaded.api.ReplacementBlock;

@Optional.InterfaceList(value={@Optional.Interface(iface="IFactoryFertilizable", modid="MineFactoryReloaded"), @Optional.Interface(iface="IFactoryPlantable", modid="MineFactoryReloaded")})
public class BlockHighlandsSapling
extends BlockSapling
implements IPlantable,
IFactoryFertilizable,
IFactoryPlantable {
    private int treeType;
    private String[] treeNames = new String[]{"Fir", "Acacia", "Poplar", "Redwood", "Eucalyptus", "GreatOak", "Beech", "DeadTree", "EvgBush", "DecBush", "Palm", "Ironwood", "Mangrove", "Ash", "AutumnOrange", "AutumnYellow"};
    private int[] growTimes = new int[]{5, 3, 3, 10, 6, 5, 2, 1, 1, 1, 2, 15, 2, 8, 2, 2};

    public BlockHighlandsSapling(int type) {
        float var3 = 0.4f;
        this.func_149676_a(0.5f - var3, 0.0f, 0.5f - var3, 0.5f + var3, var3 * 2.0f, 0.5f + var3);
        this.func_149647_a(Highlands.tabHighlands);
        this.treeType = type;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("Highlands:sapling" + this.treeNames[this.treeType]);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.field_149761_L;
    }

    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(block, 1, this.treeType));
    }

    public boolean func_149718_j(World par1World, int par2, int par3, int par4) {
        Block soil = par1World.func_147439_a(par2, par3 - 1, par4);
        return (par1World.func_72883_k(par2, par3, par4) >= 8 || par1World.func_72937_j(par2, par3, par4)) && soil != null && this.isSoilGoodForSaplingType(soil, par1World, par2, par3, par4);
    }

    private boolean isSoilGoodForSaplingType(Block soil, World par1World, int par2, int par3, int par4) {
        if (soil.canSustainPlant((IBlockAccess)par1World, par2, par3 - 1, par4, ForgeDirection.UP, (IPlantable)this)) {
            return true;
        }
        if (this.treeType == 0 && soil == Blocks.field_150433_aE) {
            return true;
        }
        if (this.treeType == 10 && soil == Blocks.field_150354_m) {
            return true;
        }
        return this.treeType == 12 && soil == Blocks.field_150355_j;
    }

    public void func_149674_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (!par1World.field_72995_K && par1World.func_72957_l(par2, par3 + 1, par4) >= 9 && par5Random.nextInt(7) == 0) {
            if (par1World.func_72805_g(par2, par3, par4) > this.growTimes[this.treeType]) {
                this.growTree(par1World, par2, par3, par4, par5Random);
            } else if (par1World.func_72805_g(par2, par3, par4) < 15) {
                par1World.func_147465_d(par2, par3, par4, (Block)this, par1World.func_72805_g(par2, par3, par4) + 1, 2);
            }
        }
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) > this.growTimes[this.treeType]) {
            this.growTree(world, x, y, z, random);
        } else if (world.func_72805_g(x, y, z) < 15) {
            world.func_147465_d(x, y, z, (Block)this, world.func_72805_g(x, y, z) + 1, 2);
        }
    }

    public boolean growTree(World par1World, int i, int j, int k, Random r) {
        boolean replaceSapling;
        int meta = par1World.func_72805_g(i, j, k);
        boolean isTreeGrowSuccess = true;
        int[] treeWideSaplings = new int[4];
        boolean growWideTree = false;
        int[] xysw = this.growTreeWide(par1World, i, j, k);
        if (xysw != null) {
            growWideTree = true;
            treeWideSaplings[0] = par1World.func_72805_g(xysw[0], j, xysw[1]);
            treeWideSaplings[1] = par1World.func_72805_g(xysw[0] + 1, j, xysw[1]);
            treeWideSaplings[2] = par1World.func_72805_g(xysw[0], j, xysw[1] + 1);
            treeWideSaplings[3] = par1World.func_72805_g(xysw[0] + 1, j, xysw[1] + 1);
            par1World.func_147465_d(xysw[0], j, xysw[1], Blocks.field_150350_a, 0, 2);
            par1World.func_147465_d(xysw[0] + 1, j, xysw[1], Blocks.field_150350_a, 0, 2);
            par1World.func_147465_d(xysw[0], j, xysw[1] + 1, Blocks.field_150350_a, 0, 2);
            par1World.func_147465_d(xysw[0] + 1, j, xysw[1] + 1, Blocks.field_150350_a, 0, 2);
        }
        boolean bl = replaceSapling = this.treeType >= 5 && this.treeType <= 9 || this.treeType == 11 || this.treeType == 14 || this.treeType == 15;
        if (replaceSapling) {
            par1World.func_147465_d(i, j, k, Blocks.field_150350_a, 0, 2);
        }
        if (this.treeType == 0) {
            isTreeGrowSuccess = growWideTree ? new WorldGenTreeFir(10, 15, true, true).func_76484_a(par1World, r, xysw[0], j, xysw[1]) : new WorldGenTreeFir(10, 15, true, false).func_76484_a(par1World, r, i, j, k);
        }
        if (this.treeType == 1) {
            isTreeGrowSuccess = new WorldGenTreeAcacia(7, 3, true).func_76484_a(par1World, r, i, j, k);
        }
        if (this.treeType == 2) {
            isTreeGrowSuccess = new WorldGenTreePoplar(10, 4, true).func_76484_a(par1World, r, i, j, k);
        }
        if (this.treeType == 3) {
            isTreeGrowSuccess = new WorldGenTreeRedwood(35, 10, true).func_76484_a(par1World, r, i, j, k);
        }
        if (this.treeType == 4) {
            isTreeGrowSuccess = growWideTree ? new WorldGenTreeCanopy(13, 6, true, true).func_76484_a(par1World, r, xysw[0], j, xysw[1]) : new WorldGenTreeCanopy(13, 6, true, false).func_76484_a(par1World, r, i, j, k);
        }
        if (this.treeType == 5) {
            isTreeGrowSuccess = new WorldGenHighlandsBigTree(false, true, 0, 0, 2, 20).func_76484_a(par1World, r, i, j, k);
        }
        if (this.treeType == 6) {
            isTreeGrowSuccess = new WorldGenHighlandsBigTree(false, true, 2, 2, 1, 0).func_76484_a(par1World, r, i, j, k);
        }
        if (this.treeType == 7) {
            isTreeGrowSuccess = new WorldGenHighlandsBigTree(false, false, 0, 0, 1, 0).func_76484_a(par1World, r, i, j, k);
        }
        if (this.treeType == 8) {
            isTreeGrowSuccess = new WorldGenHighlandsShrub(1, 1).func_76484_a(par1World, r, i, j, k);
        }
        if (this.treeType == 9) {
            isTreeGrowSuccess = new WorldGenHighlandsShrub(0, 0).func_76484_a(par1World, r, i, j, k);
        }
        if (this.treeType == 10) {
            isTreeGrowSuccess = new WorldGenTreePalm(8, 3, true).func_76484_a(par1World, r, i, j, k);
        }
        if (this.treeType == 11) {
            isTreeGrowSuccess = new WorldGenTreeIronwood(25, 50, true).func_76484_a(par1World, r, i, j, k);
        }
        if (this.treeType == 12) {
            isTreeGrowSuccess = new WorldGenTreeMangrove(4, 2, false).func_76484_a(par1World, r, i, j, k);
        }
        if (this.treeType == 13) {
            isTreeGrowSuccess = new WorldGenTreeAsh(16, 8, false).func_76484_a(par1World, r, i, j, k);
        }
        if (this.treeType == 14) {
            isTreeGrowSuccess = new WorldGenAutumnTree(true, 4, Blocks.field_150364_r, HighlandsBlocks.autumnOrangeLeaves).func_76484_a(par1World, r, i, j, k);
        }
        if (this.treeType == 15) {
            isTreeGrowSuccess = new WorldGenAutumnTree(true, 4, Blocks.field_150364_r, HighlandsBlocks.autumnYellowLeaves).func_76484_a(par1World, r, i, j, k);
        } else if (!isTreeGrowSuccess && replaceSapling && par1World.func_147437_c(i, j, k)) {
            par1World.func_147465_d(i, j, k, (Block)this, meta, 2);
        }
        return isTreeGrowSuccess;
    }

    public int[] growTreeWide(World world, int i, int j, int k) {
        if (world.func_147439_a(i + 1, j, k) == this && world.func_147439_a(i, j, k + 1) == this && world.func_147439_a(i + 1, j, k + 1) == this) {
            return new int[]{i, k};
        }
        if (world.func_147439_a(--i + 1, j, k) == this && world.func_147439_a(i, j, k + 1) == this && world.func_147439_a(i + 1, j, k + 1) == this) {
            return new int[]{i, k};
        }
        if (world.func_147439_a(i + 1, j, --k) == this && world.func_147439_a(i, j, k + 1) == this && world.func_147439_a(i + 1, j, k + 1) == this) {
            return new int[]{i, k};
        }
        if (world.func_147439_a(++i + 1, j, k) == this && world.func_147439_a(i, j, k + 1) == this && world.func_147439_a(i + 1, j, k + 1) == this) {
            return new int[]{i, k};
        }
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public EnumPlantType getPlantType(World world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public int getPlantMetadata(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    @Override
    @Optional.Method(modid="MineFactoryReloaded")
    public Block getPlant() {
        return this;
    }

    @Override
    @Optional.Method(modid="MineFactoryReloaded")
    public boolean canFertilize(World world, int x, int y, int z, FertilizerType fertilizerType) {
        return world.func_147439_a(x, y, z) == this;
    }

    @Override
    @Optional.Method(modid="MineFactoryReloaded")
    public boolean fertilize(World world, Random rand, int x, int y, int z, FertilizerType fertilizerType) {
        return this.growTree(world, x, y, z, rand);
    }

    @Override
    @Optional.Method(modid="MineFactoryReloaded")
    public Item getSeed() {
        return Item.func_150898_a((Block)this);
    }

    @Override
    @Optional.Method(modid="MineFactoryReloaded")
    public ReplacementBlock getPlantedBlock(World world, int x, int y, int z, ItemStack stack) {
        return new ReplacementBlock((Block)this);
    }

    @Override
    @Optional.Method(modid="MineFactoryReloaded")
    public boolean canBePlantedHere(World world, int x, int y, int z, ItemStack stack) {
        return this.isValidPosition(world, x, y, z, stack.func_77960_j());
    }

    @Override
    @Optional.Method(modid="MineFactoryReloaded")
    public boolean canBePlanted(ItemStack stack, boolean forFermenting) {
        return true;
    }

    @Override
    @Optional.Method(modid="MineFactoryReloaded")
    public void prePlant(World world, int x, int y, int z, ItemStack stack) {
    }

    @Override
    @Optional.Method(modid="MineFactoryReloaded")
    public void postPlant(World world, int x, int y, int z, ItemStack stack) {
    }

    public boolean isValidPosition(World world, int x, int y, int z, int meta) {
        if (world.func_147437_c(x, y, z)) {
            Block currentBlock = world.func_147439_a(x, y - 1, z);
            if (this.treeType == 0 && currentBlock == Blocks.field_150433_aE) {
                return true;
            }
            if (this.treeType == 10 && currentBlock == Blocks.field_150354_m) {
                return true;
            }
            if (this.treeType == 12 && currentBlock == Blocks.field_150355_j) {
                return true;
            }
            if (currentBlock == Blocks.field_150349_c || currentBlock == Blocks.field_150346_d) {
                return true;
            }
        }
        return false;
    }
}

