/*
 * Decompiled with CFR 0.152.
 */
package highlands.overworld;

import highlands.worldgen.layer.GenLayerHL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class WorldChunkManagerHL
extends WorldChunkManager {
    private GenLayer mbGenBiomes;
    private GenLayer mbBiomeIndexLayer;
    private BiomeCache mbBiomeCache = new BiomeCache((WorldChunkManager)this);
    private List<BiomeGenBase> mbBiomesToSpawnIn = new ArrayList<BiomeGenBase>();

    protected WorldChunkManagerHL() {
        this.mbBiomesToSpawnIn.addAll(allowedBiomes);
    }

    public WorldChunkManagerHL(long seed, WorldType worldType) {
        this();
        GenLayer[] agenlayer = GenLayerHL.initializeAllBiomeGenerators(seed, worldType);
        agenlayer = this.getModdedBiomeGenerators(worldType, seed, agenlayer);
        this.mbGenBiomes = agenlayer[0];
        this.mbBiomeIndexLayer = agenlayer[1];
    }

    public WorldChunkManagerHL(World par1World) {
        this(par1World.func_72905_C(), par1World.func_72912_H().func_76067_t());
    }

    public ChunkPosition func_150795_a(int x, int z, int radius, List biomesToSpawnIn, Random random) {
        int spawnSearchRadius = 16;
        IntCache.func_76446_a();
        int l = x - spawnSearchRadius >> 2;
        int i1 = z - spawnSearchRadius >> 2;
        int j1 = x + spawnSearchRadius >> 2;
        int k1 = z + spawnSearchRadius >> 2;
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        int[] aint = this.mbGenBiomes.func_75904_a(l, i1, l1, i2);
        ChunkPosition chunkposition = null;
        int j2 = 0;
        for (int k2 = 0; k2 < l1 * i2; ++k2) {
            int l2 = l + k2 % l1 << 2;
            int i3 = i1 + k2 / l1 << 2;
            BiomeGenBase biomegenbase = BiomeGenBase.func_150568_d((int)aint[k2]);
            if (!biomesToSpawnIn.contains(biomegenbase) || chunkposition != null && random.nextInt(j2 + 1) != 0) continue;
            chunkposition = new ChunkPosition(l2, 0, i3);
            ++j2;
        }
        return chunkposition;
    }

    public boolean func_76940_a(int par1, int par2, int par3, List par4List) {
        IntCache.func_76446_a();
        int l = par1 - par3 >> 2;
        int i1 = par2 - par3 >> 2;
        int j1 = par1 + par3 >> 2;
        int k1 = par2 + par3 >> 2;
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        int[] aint = this.mbGenBiomes.func_75904_a(l, i1, l1, i2);
        try {
            for (int j2 = 0; j2 < l1 * i2; ++j2) {
                BiomeGenBase biomegenbase = BiomeGenBase.func_150568_d((int)aint[j2]);
                if (par4List.contains(biomegenbase)) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
            crashreportcategory.func_71507_a("Layer", (Object)this.mbGenBiomes.toString());
            crashreportcategory.func_71507_a("x", (Object)par1);
            crashreportcategory.func_71507_a("z", (Object)par2);
            crashreportcategory.func_71507_a("radius", (Object)par3);
            crashreportcategory.func_71507_a("allowed", (Object)par4List);
            throw new ReportedException(crashreport);
        }
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        int[] aint = this.mbGenBiomes.func_75904_a(par2, par3, par4, par5);
        try {
            for (int i1 = 0; i1 < par4 * par5; ++i1) {
                par1ArrayOfBiomeGenBase[i1] = BiomeGenBase.func_150568_d((int)aint[i1]);
            }
            return par1ArrayOfBiomeGenBase;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
            crashreportcategory.func_71507_a("biomes[] size", (Object)par1ArrayOfBiomeGenBase.length);
            crashreportcategory.func_71507_a("x", (Object)par2);
            crashreportcategory.func_71507_a("z", (Object)par3);
            crashreportcategory.func_71507_a("w", (Object)par4);
            crashreportcategory.func_71507_a("h", (Object)par5);
            throw new ReportedException(crashreport);
        }
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5, boolean par6) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        if (par6 && par4 == 16 && par5 == 16 && (par2 & 0xF) == 0 && (par3 & 0xF) == 0) {
            BiomeGenBase[] abiomegenbase1 = this.mbBiomeCache.func_76839_e(par2, par3);
            System.arraycopy(abiomegenbase1, 0, par1ArrayOfBiomeGenBase, 0, par4 * par5);
            return par1ArrayOfBiomeGenBase;
        }
        int[] aint = this.mbBiomeIndexLayer.func_75904_a(par2, par3, par4, par5);
        for (int i1 = 0; i1 < par4 * par5; ++i1) {
            par1ArrayOfBiomeGenBase[i1] = BiomeGenBase.func_150568_d((int)aint[i1]);
        }
        return par1ArrayOfBiomeGenBase;
    }

    public BiomeGenBase func_76935_a(int par1, int par2) {
        return this.mbBiomeCache.func_76837_b(par1, par2);
    }

    public void func_76938_b() {
        this.mbBiomeCache.func_76838_a();
    }

    public List func_76932_a() {
        return this.mbBiomesToSpawnIn;
    }

    public float[] func_76936_a(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5) {
            par1ArrayOfFloat = new float[par4 * par5];
        }
        int[] aint = this.mbBiomeIndexLayer.func_75904_a(par2, par3, par4, par5);
        for (int i1 = 0; i1 < par4 * par5; ++i1) {
            try {
                float f = (float)BiomeGenBase.func_150568_d((int)aint[i1]).func_76744_g() / 65536.0f;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                par1ArrayOfFloat[i1] = f;
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return par1ArrayOfFloat;
    }
}

