/*
 * Decompiled with CFR 0.152.
 */
package highlands.worldgen;

import highlands.Highlands;
import highlands.api.HighlandsBlocks;
import highlands.worldgen.WorldGenHighlandsTreeBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WorldGenTreePoplar
extends WorldGenHighlandsTreeBase {
    public WorldGenTreePoplar(int lmd, int wmd, Block wb, Block lb, int minH, int maxH, boolean notify) {
        super(lmd, wmd, wb, lb, notify);
        this.minHeight = minH;
        this.maxHeight = maxH;
    }

    public WorldGenTreePoplar(int minH, int maxH, boolean notify) {
        this(0, 0, HighlandsBlocks.poplarWood, HighlandsBlocks.poplarLeaves, minH, maxH, notify);
        if (Highlands.vanillaBlocksFlag) {
            this.wood = Blocks.field_150364_r;
            this.woodMeta = 2;
            this.leaves = Blocks.field_150362_t;
            this.leavesMeta = 2;
        }
    }

    @Override
    public boolean func_76484_a(World world, Random random, int locX, int locY, int locZ) {
        this.worldObj = world;
        this.random = random;
        if (!this.isLegalTreePosition(world, locX, locY, locZ)) {
            return false;
        }
        if (!this.isCubeClear(locX, locY + 3, locZ, 1, 8)) {
            return false;
        }
        int treeHeight = this.minHeight + random.nextInt(this.maxHeight);
        for (int i = 0; i < treeHeight; ++i) {
            this.setBlockInWorld(locX, locY + i, locZ, this.wood, this.woodMeta);
        }
        int h = locY + 3;
        this.generateLeafLayerCircle(world, random, 1.0, locX, locZ, h);
        this.generateLeafLayerCircle(world, random, 1.5, locX, locZ, ++h);
        this.generateLeafLayerCircle(world, random, 2.0, locX, locZ, ++h);
        ++h;
        while (h < locY + treeHeight) {
            this.generateLeafLayerCircleNoise(world, random, 2.8, locX, locZ, h);
            ++h;
        }
        this.generateLeafLayerCircleNoise(world, random, 2.0, locX, locZ, h);
        this.generateLeafLayerCircleNoise(world, random, 1.5, locX, locZ, ++h);
        this.generateLeafLayerCircleNoise(world, random, 1.0, locX, locZ, ++h);
        this.setBlockInWorld(locX, ++h, locZ, this.leaves, this.leavesMeta);
        this.setBlockInWorld(locX, ++h, locZ, this.leaves, this.leavesMeta);
        this.worldObj = null;
        return true;
    }
}

