/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.keywizard;

import committee.nova.keywizard.util.KeyboardLayout;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.util.Objects;
import net.minecraftforge.common.config.Configuration;

public class KeyWizardConfig {
    public static Configuration config;
    private static boolean openFromControlsGui;
    private static int maxMouseButtons;
    private static String layoutStr;
    public static KeyboardLayout layout;

    public static void init(FMLPreInitializationEvent event) {
        config = new Configuration(new File(event.getModConfigurationDirectory(), "KeyboardWizard.cfg"));
        config.load();
        openFromControlsGui = config.getBoolean("openFromControlsGui", "general", true, "If true, keyboard wizard will be accessible through a button or a keybinding in the controls gui. (Default: F8)");
        maxMouseButtons = config.getInt("maxMouseButtons", "general", 5, 3, 15, "The number of mouse buttons to show (default:5).");
        layoutStr = config.getString("layout", "general", "QWERTY", "Valid values: QWERTY, NUMPAD, AUXILIARY");
        config.save();
    }

    public static int getMaxMouseButtons() {
        return maxMouseButtons;
    }

    public static boolean canOpenFromControlsGui() {
        return openFromControlsGui;
    }

    public static KeyboardLayout getLayout() {
        for (KeyboardLayout l : KeyboardLayout.values()) {
            if (!Objects.equals(layoutStr, l.getDisplayName())) continue;
            return l;
        }
        return null;
    }

    static {
        layout = KeyboardLayout.QWERTY;
    }
}

