/*
 * Decompiled with CFR 0.152.
 */
package com.mwutilities.tileentities;

import com.mwutilities.utils.MetaItem;
import fox.spiteful.avaritia.crafting.ExtremeCraftingManager;
import gnu.trove.TIntCollection;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;

public class TileEntityExtremeAutoCrafter
extends TileEntity
implements ISidedInventory {
    private static final int[] slotsForAllSides = new int[82];
    private final ItemStack[] itemStacks = new ItemStack[163];
    private final InventoryCrafting craftingMatrix = new ExtremeCraftingMatrix();
    private int outputStackSize = 0;
    private boolean recipeChanged = true;
    private TIntIntMap patternMap = null;
    private int coolDownTime = 10;

    public void func_145845_h() {
        ItemStack output;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (--this.coolDownTime != 0) {
            return;
        }
        this.coolDownTime = 10;
        if (this.recipeChanged) {
            this.recipeChanged = false;
            System.out.println("Recipe changed");
            output = ExtremeCraftingManager.getInstance().findMatchingRecipe(this.craftingMatrix, this.field_145850_b);
            ItemStack slotStack = this.func_70301_a(162);
            if (!(output == null || slotStack == null || slotStack.func_77973_b() != output.func_77973_b() || output.func_77981_g() && output.func_77960_j() != slotStack.func_77960_j())) {
                this.patternMap = MetaItem.getKeySizeMap(81, 162, this.itemStacks);
                this.outputStackSize = output.field_77994_a;
            } else if (slotStack != null && slotStack.field_77994_a > 0) {
                this.patternMap = null;
            } else if (output == null && slotStack != null && slotStack.field_77994_a == 0) {
                this.itemStacks[162] = null;
                this.patternMap = null;
                this.func_70296_d();
            } else if (output != null) {
                this.outputStackSize = output.field_77994_a;
                output.field_77994_a = 0;
                this.itemStacks[162] = output;
                this.patternMap = MetaItem.getKeySizeMap(81, 162, this.itemStacks);
                this.func_70296_d();
            }
        }
        if (this.patternMap != null && this.itemStacks[162] == null) {
            output = ExtremeCraftingManager.getInstance().findMatchingRecipe(this.craftingMatrix, this.field_145850_b);
            if (output == null) {
                this.patternMap = null;
                return;
            }
            this.outputStackSize = output.field_77994_a;
            output.field_77994_a = 0;
            this.itemStacks[162] = output;
        }
        if (this.patternMap == null) {
            return;
        }
        ItemStack outputStack = this.itemStacks[162];
        if (outputStack.field_77994_a + this.outputStackSize > outputStack.func_77976_d() || !this.matches(MetaItem.getSmartKeySizeMap(0, 81, this.itemStacks), this.patternMap)) {
            return;
        }
        this.cleanInput();
        outputStack.field_77994_a += this.outputStackSize;
        this.func_70296_d();
    }

    private boolean matches(@Nonnull TIntIntMap inputMap, @Nonnull TIntIntMap patternMap) {
        if (inputMap.size() >= patternMap.size() && inputMap.keySet().containsAll((TIntCollection)patternMap.keySet())) {
            for (int key : patternMap.keys()) {
                if (inputMap.get(key) >= patternMap.get(key)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void cleanInput() {
        TIntIntHashMap patternMap = new TIntIntHashMap(this.patternMap);
        for (int i = 0; i < 81 && !patternMap.isEmpty(); ++i) {
            ItemStack itemStack = this.itemStacks[i];
            int key = MetaItem.get(itemStack);
            if (!patternMap.containsKey(key)) continue;
            int total = patternMap.get(key);
            int dif = MathHelper.func_76125_a((int)total, (int)1, (int)itemStack.field_77994_a);
            if (!itemStack.func_77973_b().hasContainerItem(itemStack)) {
                itemStack.field_77994_a -= dif;
            }
            if (dif - total == 0) {
                patternMap.remove(key);
            } else {
                patternMap.put(key, total - dif);
            }
            if (itemStack.field_77994_a != 0) continue;
            this.itemStacks[i] = null;
        }
    }

    public int func_70302_i_() {
        return 163;
    }

    public ItemStack func_70301_a(int slot) {
        return this.itemStacks[slot];
    }

    public ItemStack func_70298_a(int slot, int howMuch) {
        ItemStack slotStack = this.itemStacks[slot];
        if (slotStack != null) {
            int quantity = MathHelper.func_76125_a((int)MathHelper.func_76125_a((int)howMuch, (int)1, (int)slotStack.func_77976_d()), (int)1, (int)slotStack.field_77994_a);
            ItemStack newStack = slotStack.func_77946_l();
            newStack.field_77994_a = quantity;
            if ((slotStack.field_77994_a -= quantity) == 0) {
                this.itemStacks[slot] = null;
            }
            this.func_70296_d();
            return newStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return this.itemStacks[slot];
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (slot > 80 && slot < 162) {
            this.recipeChanged = true;
        }
        this.itemStacks[slot] = itemStack;
        this.func_70296_d();
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public final boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public final Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 3, nbttagcompound);
    }

    public final void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public final void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.readCustomNBT(nbtTagCompound);
    }

    public final void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.writeCustomNBT(nbtTagCompound);
    }

    public void readCustomNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList nbtTagList = nbtTagCompound.func_150295_c("Contents", 10);
        for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
            NBTTagCompound slotCompound = nbtTagList.func_150305_b(i);
            short slot = slotCompound.func_74765_d("Slot");
            if (slot < 0 || slot >= 163) continue;
            this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)slotCompound));
        }
    }

    public void writeCustomNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < 162; ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack == null) continue;
            NBTTagCompound slotCompound = new NBTTagCompound();
            slotCompound.func_74777_a("Slot", (short)i);
            nbtTagList.func_74742_a((NBTBase)itemStack.func_77955_b(slotCompound));
        }
        ItemStack output = this.func_70301_a(162);
        if (output != null && output.field_77994_a > 0) {
            NBTTagCompound slotCompound = new NBTTagCompound();
            slotCompound.func_74777_a("Slot", (short)162);
            nbtTagList.func_74742_a((NBTBase)output.func_77955_b(slotCompound));
        }
        nbtTagCompound.func_74782_a("Contents", (NBTBase)nbtTagList);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return slot >= 0 && slot < 81;
    }

    public int[] func_94128_d(int side) {
        return slotsForAllSides;
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        return slot >= 0 && slot < 81;
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return slot == 162 && this.itemStacks[162] != null && this.itemStacks[162].field_77994_a > 0;
    }

    static {
        for (int i = 0; i < 81; ++i) {
            TileEntityExtremeAutoCrafter.slotsForAllSides[i] = i;
        }
        TileEntityExtremeAutoCrafter.slotsForAllSides[81] = 162;
    }

    public class ExtremeCraftingMatrix
    extends InventoryCrafting {
        public ExtremeCraftingMatrix() {
            super(new Container(){

                public boolean func_75145_c(EntityPlayer entityPlayer) {
                    return false;
                }
            }, 9, 9);
        }

        public ItemStack func_70301_a(int slot) {
            return TileEntityExtremeAutoCrafter.this.itemStacks[slot + 81];
        }

        public void func_70299_a(int slot, ItemStack itemStack) {
            TileEntityExtremeAutoCrafter.this.recipeChanged = true;
            ((TileEntityExtremeAutoCrafter)TileEntityExtremeAutoCrafter.this).itemStacks[slot + 81] = itemStack;
            this.func_70296_d();
        }

        public ItemStack func_70298_a(int slot, int howMuch) {
            if (TileEntityExtremeAutoCrafter.this.itemStacks[slot += 81] == null) {
                return null;
            }
            ItemStack itemStack = TileEntityExtremeAutoCrafter.this.itemStacks[slot].func_77946_l();
            if ((((TileEntityExtremeAutoCrafter)TileEntityExtremeAutoCrafter.this).itemStacks[slot].field_77994_a -= howMuch) == 0) {
                ((TileEntityExtremeAutoCrafter)TileEntityExtremeAutoCrafter.this).itemStacks[slot] = null;
            }
            itemStack.field_77994_a = howMuch;
            this.func_70296_d();
            return itemStack;
        }
    }
}

