package ru.vizzi.bp.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;

@SerializerMark(
    packetClass = ru.vizzi.bp.packet.PacketErrorMessage.class
)
public class PacketErrorMessageSerializer implements ISerializer<PacketErrorMessage> {
  public void serialize(PacketErrorMessage value, ByteBuf acc) {
    serialize_PacketErrorMessage_Generic(value, acc);
  }

  public PacketErrorMessage unserialize(ByteBuf buf) {
    return unserialize_PacketErrorMessage_Generic(buf);
  }

  void serialize_PacketErrorMessage_Generic(PacketErrorMessage value, ByteBuf acc) {
    serialize_PacketErrorMessage_Concretic(value, acc);
  }

  PacketErrorMessage unserialize_PacketErrorMessage_Generic(ByteBuf buf) {
    return unserialize_PacketErrorMessage_Concretic(buf);
  }

  void serialize_PacketErrorMessage_Concretic(PacketErrorMessage value, ByteBuf acc) {
    serialize_Boolean_Generic(value.isError(), acc);
    serialize_String_Generic(value.getMessage(), acc);
  }

  PacketErrorMessage unserialize_PacketErrorMessage_Concretic(ByteBuf buf) {
    PacketErrorMessage value = new PacketErrorMessage(unserialize_Boolean_Generic(buf), unserialize_String_Generic(buf));
    return value;
  }
}
